package com.clobot.minibasic.data.contents

import com.google.gson.JsonObject


class AccompanyContents {

    class AccompanyContentsData {
        class Page(val title: String, val desc: String, val image: String, val tts: String)
        class Place(val name: String, val poi: String, val page: Page?)

        var name: String = ""
        var image: String = ""
        val placeList = mutableListOf<Place>()

        fun load(accompanyContentsJObj: JsonObject) {

            name = accompanyContentsJObj.get("name").asString
            image = accompanyContentsJObj.get("image").asString

            placeList.clear()
            val placeListJArr = accompanyContentsJObj.get("place_list").asJsonArray

            placeListJArr.forEach {
                val placeJObj = it.asJsonObject
                val name = placeJObj.get("name").asString
                val poi = placeJObj.get("poi").asString

                val page: Page? = if (placeJObj.has("page")) {
                    val pageJObj = placeJObj.get("page").asJsonObject
                    val pageName = pageJObj.get("title").asString
                    val pageDesc = pageJObj.get("desc").asString
                    val pageImage = pageJObj.get("image").asString
                    val pageTts = pageJObj.get("tts").asString
                    Page(pageName, pageDesc, pageImage, pageTts)
                } else
                    null
                placeList.add(Place(name, poi, page))
            }
        }
    }

    var accompanyContentsData: AccompanyContentsData? = null

    fun load(guideModeJObj: JsonObject) {
        if (guideModeJObj.has("accompany_contents")) {
            accompanyContentsData = AccompanyContentsData()
            accompanyContentsData?.load(guideModeJObj.get("accompany_contents").asJsonObject)
        }
    }
}