package com.clobot.minibasic.data.caption.part

import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import com.clobot.minibasic.R
import com.clobot.minibasic.data.caption.CaptionManager
import com.clobot.minibasic.data.caption.CaptionManager.updateCaptionView
import com.clobot.minibasic.data.caption.CaptionPart
import com.clobot.minibasic.data.mode.ModeManager
import com.clobot.minibasic.data.operation.OperationManager
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.view.layer2_caption.CaptionPartView
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.launch

class OperationCaptionPart(captionManager: CaptionManager): CaptionPart(captionManager) {

    val operationCaptionPartView: OperationCaptionPartView
        get() {
            return OperationCaptionPartView(isShow, OperationManager.stateSf.value?.mode != ModeManager.Mode.REST)
        }

    init {
        MainScope().launch {
            OperationManager.stateSf.collect() {
                updateCaptionView()
            }
        }
    }
}


class OperationCaptionPartView(isShow: Boolean, val isOpen: Boolean) : CaptionPartView(isShow)

@Composable
fun OperationCaptionPartScreen(operationPartView: OperationCaptionPartView) {
    if (!operationPartView.isOpen)
        MiniImage(R.drawable.caption_rest, Modifier.lp(1519 - 90, 25, 45, 45))
}
