package com.clobot.minibasic.data.caption.part

import androidx.compose.foundation.clickable
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import com.clobot.minibasic.R
import com.clobot.minibasic.data.caption.CaptionManager
import com.clobot.minibasic.data.caption.CaptionPart
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.view.layer2_caption.CaptionPartView
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.channels.Channel
import kotlinx.coroutines.launch

class NaviCaptionPart(captionManager: CaptionManager) : CaptionPart(captionManager, false) {

    enum class Result {
        BACK, HOME,
    }

    val naviCaptionPartView: NaviCaptionPartView
        get() {
            return NaviCaptionPartView(isShow, onBack = { onBack() }, onHome = { onHome() })
        }

    private fun onBack() {
        MainScope().launch {
            touchChannel.send(Result.BACK)
        }
    }
    private fun onHome() {
        MainScope().launch {
            touchChannel.send(Result.HOME)
        }
    }

    private val touchChannel = Channel<Result>()
    suspend fun receive(): Result {
        return touchChannel.receive()
    }
}

class NaviCaptionPartView(isShow: Boolean, val onBack: () -> Unit, val onHome: () -> Unit) : CaptionPartView(isShow)

@Composable
fun NaviCaptionPartScreen(naviCaptionPartView: NaviCaptionPartView) {
    MiniImage(
        R.drawable.caption_navi_back_btn,
        Modifier
            .lp(38, 17, 61, 61)
            .clickable { naviCaptionPartView.onBack() })
    MiniImage(
        R.drawable.caption_navi_home_btn,
        Modifier
            .lp(107, 17, 61, 61)
            .clickable { naviCaptionPartView.onHome() })
}