package com.clobot.minibasic.data.caption.part

import android.os.Environment
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.res.stringResource
import com.clobot.minibasic.R
import com.clobot.minibasic.data.caption.CaptionManager
import com.clobot.minibasic.data.caption.CaptionPart
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.view.layer2_caption.CaptionPartView
import com.skydoves.landscapist.coil.CoilImage
import java.io.File

class LogoCaptionPart(captionManager: CaptionManager) : CaptionPart(captionManager) {
    val logoCaptionPartView: LogoCaptionPartView
        get() {
            return LogoCaptionPartView(isShow, File(Environment.getExternalStorageDirectory().path + "/MiniBasic/logo.png").isFile)
        }

}

class LogoCaptionPartView(isShow: Boolean, val isLogoImage: Boolean) : CaptionPartView(isShow)

@Composable
fun LogoCaptionPartScreen(logoCaptionPartView: LogoCaptionPartView) {
    if (logoCaptionPartView.isLogoImage) {
        CoilImage(
            imageModel = File(
                Environment.getExternalStorageDirectory().path + "/" + stringResource(R.string.app_name),
                "logo.png"
            ),
            Modifier.lp(851, 24, 218, 48),
            contentDescription = "",
            contentScale = ContentScale.FillBounds
        )
    } else
        MiniImage(R.drawable.caption_logo, Modifier.lp(851, 24, 218, 48))
}
