package com.clobot.minibasic.data.caption.part

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextOverflow
import com.clobot.minibasic.data.ClockManager
import com.clobot.minibasic.data.caption.CaptionManager
import com.clobot.minibasic.data.caption.CaptionPart
import com.clobot.minibasic.data.task.MiniText
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.data.task.lpToSp
import com.clobot.minibasic.view.layer2_caption.CaptionPartView
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.launch
import java.time.LocalDateTime
import java.time.format.DateTimeFormatter

class ClockCaptionPart(captionManager: CaptionManager): CaptionPart(captionManager) {

    val clockCaptionPartView: ClockCaptionPartView
        get() {
            return ClockCaptionPartView(isShow, ClockManager.dateTimeSf.value)
        }

    init {
        MainScope().launch {
            ClockManager.dateTimeSf.collect() {
                captionManager.updateCaptionView()
            }
        }
    }
}


class ClockCaptionPartView(isShow: Boolean, val localDateTime: LocalDateTime) : CaptionPartView(isShow)

@Composable
fun ClockCaptionPartScreen(captionPartView: ClockCaptionPartView) {
    Box(Modifier.lp(1590, 24, 130, 48)) {
        Box(
            modifier = Modifier
                .fillMaxSize(),
            contentAlignment = Alignment.CenterEnd,
        ) {
            MiniText(
                modifier = Modifier.wrapContentSize(),
                color = Color.White,
                fontSize = lpToSp(24),
                text = captionPartView.localDateTime.format(DateTimeFormatter.ofPattern("hh:mm a")),
                fontWeight = FontWeight.Bold,
                overflow = TextOverflow.Visible,
            )

        }
    }
}
