package com.clobot.minibasic.data.caption.part

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.LinearProgressIndicator
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.draw.scale
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.unit.dp
import com.clobot.minibasic.R
import com.clobot.minibasic.data.RobotManager
import com.clobot.minibasic.data.caption.CaptionManager
import com.clobot.minibasic.data.caption.CaptionPart
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.MiniText
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.data.task.lpToSp
import com.clobot.minibasic.view.layer2_caption.CaptionPartView
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.launch

class BatteryCaptionPart(captionManager: CaptionManager): CaptionPart(captionManager) {
    val batteryCaptionPartView: BatteryCaptionPartView
        get() {
            return BatteryCaptionPartView(isShow, RobotManager.batteryLevelSf.value ?: 0, RobotManager.isChargingSf.value == true)
        }


    init {
        MainScope().launch {
            RobotManager.batteryLevelSf.collect() {
                updateCaptionPartView()
            }
        }
        MainScope().launch {
            RobotManager.isChargingSf.collect() {
                updateCaptionPartView()
            }
        }

    }
}
class BatteryCaptionPartView(isShow: Boolean, val batteryLevel: Int, val isCharging: Boolean) : CaptionPartView(isShow)

@Composable
fun BatteryCaptionPartScreen(captionPartView: BatteryCaptionPartView) {
    Box(Modifier.lp(1760, 24, 70, 48)) {
        Box(
            modifier = Modifier
                .fillMaxSize(),
            contentAlignment = Alignment.CenterEnd,
        ) {
            MiniText(
                modifier = Modifier.wrapContentSize(),
                color = if (captionPartView.batteryLevel >= 20) Color.White else Color.Red,
                fontSize = lpToSp(24),
                text = "${captionPartView.batteryLevel}%",
                fontWeight = FontWeight.Bold,
                overflow = TextOverflow.Visible,
            )

        }

    }
    MiniImage(resId = R.drawable.caption_battery, Modifier.lp(1844, 34, 56, 28))

    Box(Modifier.lp(1852, 38, 44, 20)) {
        Box(modifier = Modifier
            .fillMaxSize()
            .scale(scaleX = -1f, scaleY = 1f),
            contentAlignment = Alignment.Center,
        ) {
            LinearProgressIndicator(
                modifier = Modifier
                    .fillMaxSize()
                    .clip(RoundedCornerShape(1.dp))
                    .align(Alignment.Center),
                progress = captionPartView.batteryLevel / 100f,
                color = if (captionPartView.batteryLevel > 20) Color.White else Color.Red,
                trackColor = Color.Transparent,
            )
        }
    }
    if (captionPartView.isCharging)
        MiniImage(resId = R.drawable.caption_charging, Modifier.lp(1865, 38, 18, 20))
}
