package com.clobot.minibasic.data.caption.part

import androidx.compose.foundation.clickable
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import com.clobot.minibasic.R
import com.clobot.minibasic.data.admin.AdminManager
import com.clobot.minibasic.data.caption.CaptionManager
import com.clobot.minibasic.data.caption.CaptionPart
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.view.layer2_caption.CaptionPartView

class AdminCaptionPart(captionManager: CaptionManager): CaptionPart(captionManager) {
    val adminCaptionPartView: AdminCaptionPartView
        get() {
            return AdminCaptionPartView(isShow, onClick = { onClick() })
        }
    private fun onClick() {
        AdminManager.setIsShow(true)
    }
}
class AdminCaptionPartView(isShow: Boolean, val onClick: () -> Unit) : CaptionPartView(isShow)

@Composable
fun AdminCaptionPartScreen(adminCaptionPartView: AdminCaptionPartView) {
    MiniImage(
        R.drawable.caption_admin_btn,
        Modifier
            .lp(1493, 17, 61, 61)
            .clickable { adminCaptionPartView.onClick() })
}