package com.clobot.minibasic.data.caption

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import com.clobot.minibasic.data.caption.part.AdminCaptionPart
import com.clobot.minibasic.data.caption.part.AdminCaptionPartScreen
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.view.layer2_caption.CaptionView
import com.clobot.minibasic.data.caption.part.BatteryCaptionPart
import com.clobot.minibasic.data.caption.part.BatteryCaptionPartScreen
import com.clobot.minibasic.data.caption.part.ClockCaptionPart
import com.clobot.minibasic.data.caption.part.ClockCaptionPartScreen
import com.clobot.minibasic.data.caption.part.LogoCaptionPart
import com.clobot.minibasic.data.caption.part.LogoCaptionPartScreen
import com.clobot.minibasic.data.caption.part.NaviCaptionPart
import com.clobot.minibasic.data.caption.part.NaviCaptionPartScreen
import com.clobot.minibasic.data.caption.part.OperationCaptionPart
import com.clobot.minibasic.data.caption.part.OperationCaptionPartScreen
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update


abstract class CaptionPart(private val captionManager: CaptionManager, initIsShow: Boolean = true) {
    var isShow: Boolean = initIsShow
        set(value) {
            field = value
            updateCaptionPartView()
        }

    protected fun updateCaptionPartView() {
        captionManager.updateCaptionView()
    }
}

object CaptionManager {

    private val captionView: CaptionView
        get() {
            return CaptionView(
                naviCaptionPart.naviCaptionPartView,
                logoCaptionPart.logoCaptionPartView,
                adminCaptionPart.adminCaptionPartView,
                batteryCaptionPart.batteryCaptionPartView,
                clockCaptionPart.clockCaptionPartView,
                operationCaptionPart.operationCaptionPartView,
            )
        }


    val naviCaptionPart = NaviCaptionPart(this)
    val logoCaptionPart = LogoCaptionPart(this)
    val adminCaptionPart = AdminCaptionPart(this)
    val batteryCaptionPart = BatteryCaptionPart(this)
    val clockCaptionPart = ClockCaptionPart(this)
    val operationCaptionPart = OperationCaptionPart(this)


    private val isShowMsf = MutableStateFlow(true)
    val isShowSf = isShowMsf.asStateFlow()
    fun setIsShow(isShow: Boolean) {
        isShowMsf.update {
            isShow
        }
    }

    private val captionViewMsf = MutableStateFlow(captionView)
    val captionViewSf = captionViewMsf.asStateFlow()

    fun updateCaptionView() {
        captionViewMsf.update {
            captionView
        }
    }


}

@Composable
fun BaseCaptionScreen(contents: @Composable () -> Unit) {
    Box(Modifier.lp(0, 0, MiniCompose.bg_width, 96)) {
        Box(
            Modifier
                .fillMaxSize()
                .background(Color.Black)
        ) {
            contents()
        }
    }
}

@Composable
fun CaptionScreen(captionView: CaptionView) {
    if (captionView.naviCaptionPartView.isShow)
        NaviCaptionPartScreen(captionView.naviCaptionPartView)
    if (captionView.logoCaptionPartView.isShow)
        LogoCaptionPartScreen(captionView.logoCaptionPartView)
    if (captionView.adminCaptionPartView.isShow)
        AdminCaptionPartScreen(captionView.adminCaptionPartView)
    if (captionView.batteryCaptionPartView.isShow)
        BatteryCaptionPartScreen(captionView.batteryCaptionPartView)
    if (captionView.clockCaptionPartView.isShow)
        ClockCaptionPartScreen(captionView.clockCaptionPartView)
    if (captionView.operationCaptionPartView.isShow)
        OperationCaptionPartScreen(captionView.operationCaptionPartView)
}
