package com.clobot.minibasic.data.admin.tab

import android.os.Environment
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.foundation.text.KeyboardActions
import androidx.compose.foundation.text.KeyboardOptions
import androidx.compose.material3.Button
import androidx.compose.material3.CircularProgressIndicator
import androidx.compose.material3.TextField
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.ExperimentalComposeUiApi
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.platform.LocalSoftwareKeyboardController
import androidx.compose.ui.text.input.ImeAction
import androidx.compose.ui.text.input.KeyboardType
import androidx.compose.ui.text.input.PasswordVisualTransformation
import androidx.compose.ui.unit.dp
import com.clobot.minibasic.R
import com.clobot.minibasic.data.update.ResourceUpdateManager
import com.clobot.minibasic.data.admin.AdminManager
import com.clobot.minibasic.data.admin.AdminTab
import com.clobot.minibasic.data.admin.AdminText
import com.clobot.minibasic.data.devel.DevelManager
import com.clobot.minibasic.data.update.DirDownloader
import com.clobot.minibasic.data.update.FileDownloader
import com.clobot.minibasic.view.layer5_admin.AdminTabView
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.Job
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch
import java.io.File

class ResourceUpdateAdminTab(adminManager: AdminManager) : AdminTab(adminManager) {
    override val name: String
        get() = "업데이트\n(리소스)"

    override val adminTabView: AdminTabView
        get() = AdminTabView.ResourceUpdate(
            ResourceUpdateManager.siteName, {
                ResourceUpdateManager.siteName = it
                updateAdminTabView()
            }, ResourceUpdateManager.sitePw, {
                ResourceUpdateManager.sitePw = it
                updateAdminTabView()
            }, isUpdate, updateText, updateSubText, { onUpdate() }, { onDeleteAll() })

    private var hostName = "download.clobot.co.kr"
    private var ftpPort = 21
    private var httpPort = 8088
    private var remoteDir = "mini/tm/mini_basic/resource/"

    private var job: Job? = null
    private var isUpdate = false
        set(value) {
            field = value
            updateAdminTabView()
        }
    private var updateText = ""
        set(value) {
            field = value
            updateAdminTabView()
        }
    private var updateSubText = ""
        set(value) {
            field = value
            updateAdminTabView()
        }


    private fun onUpdate() {

        isUpdate = true

        job = CoroutineScope(Dispatchers.IO).launch {
            try {
                updateText = "checking...."
                updateSubText = ""
                delay(1000)

                DirDownloader().download(
                    hostName,
                    ftpPort,
                    remoteDir + "/${ResourceUpdateManager.siteName}",
                    false
                ).collect() { dirResult ->
                    when (dirResult) {
                        is DirDownloader.Result.Success -> {
                            val fileDirList: MutableList<String> = arrayListOf()
                            for (dirFtpFile in dirResult.dirFtpFileArr) {
                                fileDirList.add("${dirFtpFile.dir}/${dirFtpFile.ftpFile.name}")
                            }



                            updateText = "downloading...."
                            updateSubText = "${fileDirList.size} file(s) is downloading..."
                            delay(1000)

                            FileDownloader().downloads(
                                "http://${hostName}",
                                httpPort,
                                "${remoteDir}/${ResourceUpdateManager.siteName}",
                                fileDirList.toTypedArray(),
                                "${Environment.getExternalStorageDirectory()}/${
                                    ResourceUpdateManager.context.resources.getString(
                                        R.string.app_name
                                    )
                                }"
                            ).collect() { fileResult ->
                                when (fileResult) {
                                    is FileDownloader.Result.Begin -> {

                                    }

                                    is FileDownloader.Result.DownloadFile -> {
                                        when (fileResult.subResult) {
                                            is FileDownloader.Result.DownloadFile.Begin -> {
                                                updateText =
                                                    "downloading.... (${fileResult.subResult.index + 1}/${fileDirList.size})"
                                                updateSubText =
                                                    "${fileResult.subResult.localPath} begin..."
                                                delay(500)
                                            }

                                            is FileDownloader.Result.DownloadFile.Downloading -> {}
                                            is FileDownloader.Result.DownloadFile.Success -> {
                                                updateSubText =
                                                    "${fileResult.subResult.localPath} ok"
                                            }

                                            is FileDownloader.Result.DownloadFile.Fail -> {
                                                updateSubText =
                                                    "${fileResult.subResult.localPath} fail"
                                                delay(500)
                                            }
                                        }
                                    }

                                    is FileDownloader.Result.Complete -> {
                                        updateComplete()
                                    }

                                    is FileDownloader.Result.Fail -> {}
                                }
                            }
                        }

                        is DirDownloader.Result.Fail -> {
                            updateSubText = "fail: ${dirResult.message}"
                            onCancelUpdate()
                        }
                    }
                }
            } catch (e: Exception) {
            }
        }
    }

    private fun onDeleteAll() {
        val dir = File(
            "${Environment.getExternalStorageDirectory()}/${
                ResourceUpdateManager.context.resources.getString(R.string.app_name)
            }"
        )
        DevelManager.generalDevelTab.log("path: ${dir.absoluteFile}")
        if (dir.listFiles() != null) {
            for (file in dir.listFiles()) {
                if (!file.isDirectory)
                    file.delete()
            }
        }
        updateText = "삭제 완료"
    }

    private fun updateComplete() {
        job?.cancel()
        job = null
        isUpdate = false
    }

    private fun updateCancel() {
        if (job == null)
            return
        job?.cancel()
        job = null
        isUpdate = false
    }

    private fun onCancelUpdate() {
        updateCancel()
        updateText = "취소됌"
    }

}


@OptIn(ExperimentalComposeUiApi::class)
@Composable
fun ResourceUpdateAdminTabScreen(resourceUpdateAdminTabView: AdminTabView.ResourceUpdate) {
    var siteName by remember {
        mutableStateOf(resourceUpdateAdminTabView.siteName)
    }
    var sitePw by remember {
        mutableStateOf(resourceUpdateAdminTabView.sitePw)
    }
    val keyboardController = LocalSoftwareKeyboardController.current
    LazyColumn(contentPadding = PaddingValues(horizontal = 30.dp, vertical = 10.dp)) {
        item {
            Row(verticalAlignment = Alignment.CenterVertically) {
                AdminText("병원:", color = Color.White)
                TextField(
                    value = siteName, onValueChange = {
                        siteName = it
                        resourceUpdateAdminTabView.onSiteName(it)
                    },
                    singleLine = true,
                    keyboardOptions = KeyboardOptions(
                        imeAction = ImeAction.Done,
                        keyboardType = KeyboardType.Text
                    ),
                    keyboardActions = KeyboardActions(
                        onDone = {
                            keyboardController?.hide()
                        }
                    )
                )
            }
        }
        item {
            Row(verticalAlignment = Alignment.CenterVertically) {
                AdminText("코드:", color = Color.White)
                TextField(
                    value = sitePw, onValueChange = {
                        sitePw = it
                        resourceUpdateAdminTabView.onSitePw(it)
                    },
                    singleLine = true,
                    keyboardOptions = KeyboardOptions(
                        imeAction = ImeAction.Done,
                        keyboardType = KeyboardType.Password
                    ),
                    visualTransformation = PasswordVisualTransformation(),
                    keyboardActions = KeyboardActions(
                        onDone = {
                            keyboardController?.hide()
                        }
                    )
                )
            }
        }
        item {
            LazyRow(
                verticalAlignment = Alignment.CenterVertically,
                horizontalArrangement = Arrangement.spacedBy(10.dp)
            ) {
                if (resourceUpdateAdminTabView.isUpdate) {
                    item {
                        CircularProgressIndicator()
                    }
                }
                item {
                    AdminText(resourceUpdateAdminTabView.updateText, color = AdminManager.highlightTextColor)
                }
            }
        }
        item {
            AdminText(resourceUpdateAdminTabView.updateSubText, color = AdminManager.highlightTextColor)
        }
        item {
            Button(
                onClick = resourceUpdateAdminTabView.onUpdate,
            ) {
                AdminText("업데이트")
            }
        }
        item {
            Button(
                onClick = resourceUpdateAdminTabView.onDeleteAll,
            ) {
                AdminText("전부 삭제")
            }
        }
        item {
            AdminText("다운로드가 완전히 종료 후 앱을 재시작해야 화면에 새로 적용 됩니다.", color = Color.Red)
        }
    }
}
