package com.clobot.minibasic.data.admin.tab

import android.annotation.SuppressLint
import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.RadioButton
import androidx.compose.material3.Switch
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import com.clobot.minibasic.data.admin.AdminButton
import com.clobot.minibasic.data.admin.AdminManager
import com.clobot.minibasic.data.admin.AdminSpinner
import com.clobot.minibasic.data.admin.AdminTab
import com.clobot.minibasic.data.admin.AdminText
import com.clobot.minibasic.data.mode.ModeManager
import com.clobot.minibasic.data.operation.OperationManager
import com.clobot.minibasic.data.operation.ScheduleChecker
import com.clobot.minibasic.view.layer5_admin.AdminTabView

class OperationAdminTab(adminManager: AdminManager) : AdminTab(adminManager) {
    override val name: String
        get() = "운영 모드"
    override val adminTabView: AdminTabView
        get() = AdminTabView.Operation(
            OperationManager.scheduleChecker.mode,
            onMode = {
                onMode(it)
            },
            OperationManager.scheduleChecker.dayDataArr,
            OperationManager.scheduleChecker.modeTimeDataListArr,
            onSetDayData = { day, dayData ->
                onSetScheduleDayData(day, dayData)
            },
            onAddModeTimeData = { slot, index ->
                onAddModeTimeData(slot, index)
            },
            onRemoveModeTimeData = { slot, index ->
                onRemoveModeTimeData(slot, index)
            },
            onSetModeTimeData = { slot, index, modeTimeData ->
                onSetModeTimeData(slot, index, modeTimeData)
            }
        )

    private fun onMode(mode: ScheduleChecker.Mode) {
        OperationManager.scheduleChecker.mode = mode
        updateAdminTabView()
    }

    private fun onSetScheduleDayData(day: Int, dayData: ScheduleChecker.DayData) {
        OperationManager.scheduleChecker.dayDataArr[day] = dayData
        OperationManager.scheduleChecker.saveDayArr()
        updateAdminTabView()
    }
    private fun onAddModeTimeData(slot: Int, index: Int) {
        OperationManager.scheduleChecker.modeTimeDataListArr[slot].add(index, ScheduleChecker.ModeTimeData(
            ModeManager.Mode.GUIDE, 0 .. 6))
        OperationManager.scheduleChecker.saveModeTimeDataListArr()
        updateAdminTabView()
    }
    private fun onRemoveModeTimeData(slot: Int, index: Int) {
        OperationManager.scheduleChecker.modeTimeDataListArr[slot].removeAt(index)
        OperationManager.scheduleChecker.saveModeTimeDataListArr()
        updateAdminTabView()
    }
    private fun onSetModeTimeData(slot: Int, index: Int, modeTimeData: ScheduleChecker.ModeTimeData) {
        OperationManager.scheduleChecker.modeTimeDataListArr[slot][index] = modeTimeData
        OperationManager.scheduleChecker.saveModeTimeDataListArr()
        updateAdminTabView()
    }
}
@SuppressLint("RememberReturnType", "DefaultLocale")
@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun OperationTabScreen(adminTabView: AdminTabView.Operation) {
    LazyColumn(contentPadding = PaddingValues(horizontal = 10.dp, vertical = 10.dp)) {
        item {
            val name = arrayOf("항상 휴식", "항상 안내", "항상 홍보", "스케쥴에 따라")
            LazyRow(verticalAlignment = Alignment.CenterVertically) {
                ScheduleChecker.Mode.entries.forEach {
                    item {
                        RadioButton(
                            selected = adminTabView.mode == it,
                            onClick = {
                                adminTabView.onMode(it)
                            })
                        AdminText(name[it.ordinal])
                    }
                }
            }
        }
        if (adminTabView.mode == ScheduleChecker.Mode.SCHEDULE) {
            item {
                Box(modifier = Modifier.border(BorderStroke(0.dp, Color.Red))) {
                    val dayNameArr = arrayOf("월", "화", "수", "목", "금", "토", "일")
                    Column {
                        adminTabView.dayDataArr.forEachIndexed() { day, dayData ->
                            Box(modifier = Modifier
                                .fillMaxSize()
                                .wrapContentSize()) {
                                Row(modifier = Modifier.fillMaxSize(), verticalAlignment = Alignment.CenterVertically) {
                                    AdminText("${dayNameArr[day]}:  ")
                                    AdminText("운영:")
                                    Switch(
                                        checked = dayData.isOn,
                                        onCheckedChange = {
                                            adminTabView.onSetDayData(day, ScheduleChecker.DayData(it, dayData.slot))
                                        }
                                    )
                                    AdminSpinner(
                                        dayData.slot,
                                        listOf("슬롯 #1", "슬롯 #2", "슬롯 #3", "슬롯 #4", "슬롯 #5"),
                                        onSelected = {
                                            adminTabView.onSetDayData(day, ScheduleChecker.DayData(dayData.isOn, it))
                                        }
                                    )
                                }
                            }
                        }
                    }
                }
            }
            item {
                Column(modifier = Modifier.border(BorderStroke(0.dp, Color.Red))) {
                    adminTabView.modeTimeDataListArr.forEachIndexed { slot, modeTimeDataList ->
                        Box(modifier = Modifier
                            .border(BorderStroke(0.dp, Color.White))) {

                            Column(modifier = Modifier
                                .padding(5.dp)
                                .border(BorderStroke(0.dp, Color.Blue))) {

                                Box() {
                                    Row() {
                                        AdminText("슬롯 #${slot + 1}")
                                    }
                                    Row(modifier = Modifier.fillMaxSize(), horizontalArrangement = Arrangement.End) {
                                        AdminButton(onClick = {adminTabView.onAddModeTimeData(slot, 0)}) {
                                            AdminText("+")
                                        }
                                    }
                                }

                                modeTimeDataList.forEachIndexed { index, modeTimeData ->
                                    Box(modifier = Modifier.fillMaxSize()) {
                                        Column {
                                            Row(
                                                modifier = Modifier.fillMaxSize(),
                                                verticalAlignment = Alignment.CenterVertically
                                            ) {
                                                RadioButton(
                                                    selected = modeTimeData.mode == ModeManager.Mode.GUIDE,
                                                    onClick = {
                                                        adminTabView.onSetModeTimeData(
                                                            slot,
                                                            index,
                                                            ScheduleChecker.ModeTimeData(ModeManager.Mode.GUIDE, modeTimeData.timeRange)
                                                        )
                                                    },
                                                    modifier = Modifier.height(32.dp)
                                                )
                                                AdminText("안내")
                                                RadioButton(
                                                    selected = modeTimeData.mode == ModeManager.Mode.PROMOTE,
                                                    onClick = {
                                                        adminTabView.onSetModeTimeData(
                                                            slot,
                                                            index,
                                                            ScheduleChecker.ModeTimeData(ModeManager.Mode.PROMOTE, modeTimeData.timeRange)
                                                        )
                                                    },
                                                    modifier = Modifier.height(32.dp)
                                                )
                                                AdminText("홍보")
                                            }
                                            Row(
                                                modifier = Modifier.fillMaxSize(),
                                                horizontalArrangement = Arrangement.End,
                                                verticalAlignment = Alignment.CenterVertically
                                            ) {
                                                AdminButton(onClick = {
                                                    adminTabView.onRemoveModeTimeData(slot, index)
                                                }) {
                                                    AdminText("-")
                                                }

                                                AdminButton(onClick = {
                                                    adminTabView.onAddModeTimeData(slot, index)
                                                }) {
                                                    AdminText("+")
                                                }
                                            }
                                            LazyRow(verticalAlignment = Alignment.CenterVertically) {
                                                val noon1 =
                                                    (modeTimeData.timeRange.first / 60 / 60) / 12
                                                val hour1 =
                                                    (modeTimeData.timeRange.first / 60 / 60) % 12
                                                val minute1 =
                                                    (modeTimeData.timeRange.first / 60) % 60
                                                item {
                                                    AdminSpinner(
                                                        noon1,
                                                        options = listOf("AM", "PM"),
                                                        onSelected = {
                                                            adminTabView.onSetModeTimeData(
                                                                slot,
                                                                index,
                                                                ScheduleChecker.ModeTimeData(
                                                                    modeTimeData.mode,
                                                                    IntRange(
                                                                        (it * 12 + hour1) * 60 * 60 + minute1 * 60,
                                                                        modeTimeData.timeRange.last
                                                                    )
                                                                )
                                                            )
                                                        }
                                                    )
                                                }
                                                item {
                                                    AdminText(":")
                                                }
                                                item {
                                                    AdminSpinner(
                                                        hour1 % 12,
                                                        options = List(12) { i ->
                                                            String.format(
                                                                "%02d",
                                                                i
                                                            )
                                                        },
                                                        onSelected = {
                                                            adminTabView.onSetModeTimeData(
                                                                slot,
                                                                index,
                                                                ScheduleChecker.ModeTimeData(
                                                                    modeTimeData.mode,
                                                                    IntRange(
                                                                        (noon1 * 12 + it) * 60 * 60 + minute1 * 60,
                                                                        modeTimeData.timeRange.last
                                                                    )
                                                                )
                                                            )
                                                        }
                                                    )
                                                }
                                                item {
                                                    AdminText(":")
                                                }
                                                item {
                                                    AdminSpinner(
                                                        minute1 / 10,
                                                        options = List(6) { i ->
                                                            String.format(
                                                                "%02d",
                                                                i * 10
                                                            )
                                                        },
                                                        onSelected = {
                                                            adminTabView.onSetModeTimeData(
                                                                slot,
                                                                index,
                                                                ScheduleChecker.ModeTimeData(
                                                                    modeTimeData.mode,
                                                                    IntRange(
                                                                        (noon1 * 12 + it) * 60 * 60 + (it * 10) * 60,
                                                                        modeTimeData.timeRange.last
                                                                    )
                                                                )
                                                            )
                                                        }
                                                    )
                                                }
                                                item {
                                                    AdminText(" ~ ")
                                                }
                                                val noon2 = (modeTimeData.timeRange.last / 60 / 60) / 12
                                                val hour2 = (modeTimeData.timeRange.last / 60 / 60) % 12
                                                val minute2 = (modeTimeData.timeRange.last / 60) % 60
                                                item {
                                                    AdminSpinner(
                                                        noon2,
                                                        options = listOf("AM", "PM"),
                                                        onSelected = {
                                                            adminTabView.onSetModeTimeData(
                                                                slot,
                                                                index,
                                                                ScheduleChecker.ModeTimeData(
                                                                    modeTimeData.mode,
                                                                    IntRange(
                                                                        modeTimeData.timeRange.first,
                                                                        (it * 12 + hour2) * 60 * 60 + minute2 * 60
                                                                    )
                                                                )
                                                            )
                                                        }
                                                    )
                                                }
                                                item {
                                                    AdminText(":")
                                                }
                                                item {
                                                    AdminSpinner(
                                                        hour2 % 12,
                                                        options = List(12) { i ->
                                                            String.format(
                                                                "%02d",
                                                                i
                                                            )
                                                        },
                                                        onSelected = {
                                                            adminTabView.onSetModeTimeData(
                                                                slot,
                                                                index,
                                                                ScheduleChecker.ModeTimeData(
                                                                    modeTimeData.mode,
                                                                    IntRange(
                                                                        modeTimeData.timeRange.first,
                                                                        (noon2 * 12 + it) * 60 * 60 + minute2 * 60
                                                                    )
                                                                )
                                                            )
                                                        }
                                                    )
                                                }
                                                item {
                                                    AdminText(":")
                                                }
                                                item {
                                                    AdminSpinner(
                                                        minute2 / 10,
                                                        options = List(6) { i ->
                                                            String.format(
                                                                "%02d",
                                                                i * 10
                                                            )
                                                        },
                                                        onSelected = {
                                                            adminTabView.onSetModeTimeData(
                                                                slot,
                                                                index,
                                                                ScheduleChecker.ModeTimeData(
                                                                    modeTimeData.mode,
                                                                    IntRange(
                                                                        modeTimeData.timeRange.first,
                                                                        (noon2 * 12 + it) * 60 * 60 + (it * 10) * 60
                                                                    )
                                                                )
                                                            )
                                                        }
                                                    )
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
