package com.clobot.minibasic.data.admin.tab

import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.Button
import androidx.compose.material3.Switch
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import com.clobot.minibasic.data.HiddenManager
import com.clobot.minibasic.data.admin.AdminManager
import com.clobot.minibasic.data.admin.AdminTab
import com.clobot.minibasic.data.admin.AdminText
import com.clobot.minibasic.view.layer5_admin.AdminTabView
import kotlin.system.exitProcess

class EtcAdminTab(adminManager: AdminManager) : AdminTab(adminManager) {
    override val name: String
        get() = "기타"

    override val adminTabView: AdminTabView
        get() = AdminTabView.Etc(
            HiddenManager.isDevelButtonShow,
            onIsDevelButtonShow = { onIsDevelButtonShow(it) },
            onExit = {onExit()},
        )


    private fun onIsDevelButtonShow(isDevelButtonShow: Boolean) {
        HiddenManager.isDevelButtonShow = isDevelButtonShow
        updateAdminTabView()
    }

    private fun onExit() {
        System.runFinalization()
        exitProcess(0)
    }
}

@Composable
fun EtcAdminTabScreen(adminTabView: AdminTabView.Etc) {

    LazyColumn(contentPadding = PaddingValues(horizontal = 30.dp, vertical = 10.dp)) {
        item {
            Row(verticalAlignment = Alignment.CenterVertically) {
                AdminText("   Devel 버튼:", color = Color.White)
                Switch(
                    checked = adminTabView.isDevelButtonShow,
                    onCheckedChange = adminTabView.onIsDevelButtonShow
                )
            }
        }
        item {
            Button(onClick = adminTabView.onExit) {
                AdminText("강제 종료:", color = Color.White)
            }
        }
    }
}
