package com.clobot.minibasic.data.admin.tab

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.lazy.LazyRow
import androidx.compose.material3.Button
import androidx.compose.material3.ButtonDefaults
import androidx.compose.material3.CircularProgressIndicator
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.SpanStyle
import androidx.compose.ui.text.buildAnnotatedString
import androidx.compose.ui.text.withStyle
import androidx.compose.ui.unit.dp
import com.clobot.minibasic.BuildConfig
import com.clobot.minibasic.data.admin.AdminManager
import com.clobot.minibasic.data.admin.AdminTab
import com.clobot.minibasic.data.admin.AdminText
import com.clobot.minibasic.data.update.UpdateManager
import com.clobot.minibasic.view.layer5_admin.AdminTabView
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.Job
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

class AppUpdateAdminTab(adminManager: AdminManager) : AdminTab(adminManager) {
    override val name: String
        get() = "업데이트 (앱)"
    override val adminTabView: AdminTabView
        get() = AdminTabView.AppUpdate(
            BuildConfig.VERSION_NAME,
            isAutoUpdate, autoUpdateStep, autoUpdateText, autoUpdateSubText,
            onAutoUpdate = {onAutoUpdate()}, onCancelAutoUpdate = {onCancelAutoUpdate()},
            onCheck = {onCheck()},
            UpdateManager.isValidRemoteFileName(remoteFileName), onDownload = {onDownload()},
            UpdateManager.isFileExits(apkFileName), onInstall = {onInstall()},
        )


    private var hostName = "download.clobot.co.kr"
    private var ftpPort = 21
    private var httpPort = 8088
    private var remoteDir = "mini/tm/mini_basic/apk"
    private var apkFileName = "mini_basic.apk"
    private var prefix = "mini_basic_"

    private var job: Job? = null


    override fun onShow() {
        remoteFileName = ""
    }

    override fun onHide() {
        if (job != null) {
            job?.cancel()
            job = null
        }
        isAutoUpdate = false
        autoUpdateStep = 0
        autoUpdateText = ""
        autoUpdateSubText = ""
        remoteFileName = ""
    }

    private var isAutoUpdate = false
        set(value) {
            field = value
            updateAdminTabView()
        }
    private var autoUpdateStep = 0
        set(value) {
            field = value
            updateAdminTabView()
        }
    private var autoUpdateText = ""
        set(value) {
            field = value
            updateAdminTabView()
        }
    private var autoUpdateSubText = ""
        set(value) {
            field = value
            updateAdminTabView()
        }

    private var remoteFileName = ""
        set(value) {
            field = value
            updateAdminTabView()
        }
    private fun onAutoUpdate(step: Int = 0) {
        isAutoUpdate = true
        autoUpdateStep = step

        job = CoroutineScope(Dispatchers.IO).launch {
            //job = MainScope().launch {
            try {
                if (autoUpdateStep == 0 || autoUpdateStep == 1) {
                    autoUpdateText = "checking...."
                    autoUpdateSubText = ""
                    delay(1000)

                    remoteFileName = ""
                    UpdateManager.check(hostName, ftpPort, remoteDir, prefix, ".apk").collect() {
                        when (it) {
                            is UpdateManager.CheckResult.Found -> {
                                val found = if (it.version > BuildConfig.VERSION_NAME)
                                    "업데이트가 필요합니다."
                                else
                                    "이미 최신 버전입니다."

                                autoUpdateSubText = "$found  ${it.fileName} (ver. ${it.version})"
                                remoteFileName = it.fileName
                                if (it.version <= BuildConfig.VERSION_NAME)
                                    autoUpdateComplete()

                                if (autoUpdateStep == 1)
                                    autoUpdateComplete()

                            }

                            is UpdateManager.CheckResult.NotFound -> {
                                autoUpdateSubText = "not found"
                                autoUpdateCancel()
                            }

                            is UpdateManager.CheckResult.Fail -> {
                                autoUpdateSubText = "fail: ${it.errorMessage}"
                                autoUpdateCancel()
                            }
                        }
                    }
                    delay(500)
                }

                if (autoUpdateStep == 0 || autoUpdateStep == 2) {
                    autoUpdateText = "downloading...."
                    autoUpdateSubText = ""
                    delay(1000)

                    if(!UpdateManager.isValidRemoteFileName(remoteFileName)) {
                        autoUpdateSubText = "파일 이름이 없습니다."
                        autoUpdateCancel()
                    }

                    try {
                        UpdateManager.download(
                            hostName, httpPort, remoteDir, remoteFileName, apkFileName
                        ).collect() {
                            when (it) {
                                is UpdateManager.DownloadResult.Downloading -> autoUpdateSubText =
                                    it.progressMessage

                                is UpdateManager.DownloadResult.Complete -> {
                                    autoUpdateSubText = "complete: $remoteFileName"
                                    if (autoUpdateStep == 2)
                                        autoUpdateComplete()
                                }
                                is UpdateManager.DownloadResult.Fail -> {
                                    autoUpdateSubText = it.errorMessage
                                    autoUpdateCancel()
                                }
                            }
                        }
                    } catch(e: Exception) {
                        e.printStackTrace()
                        UpdateManager.deleteFile(apkFileName)
                        updateAdminTabView()
                    }
                    delay(500)
                }

                if (autoUpdateStep == 0 || autoUpdateStep == 3) {
                    autoUpdateText = "installing...."
                    autoUpdateSubText = apkFileName
                    delay(1000)

                    if (!UpdateManager.isFileExits(apkFileName)) {
                        autoUpdateSubText = "파일이 없습니다."
                        autoUpdateCancel()
                    }

                    UpdateManager.install(apkFileName)
                    if (autoUpdateStep == 3)
                        autoUpdateComplete()

                    delay(500)
                }

                if (autoUpdateStep == 0)
                    autoUpdateComplete()
            } catch(e: Exception) {
                e.printStackTrace()
            }

        }
    }
    private fun autoUpdateComplete() {
        job?.cancel()
        job = null
        isAutoUpdate = false
    }
    private fun autoUpdateCancel() {
        if (job == null)
            return
        job?.cancel()
        job = null
        isAutoUpdate = false
    }
    private fun onCancelAutoUpdate() {
        autoUpdateCancel()
        autoUpdateText = "취소됌"
    }

    private var checkResult: String = ""
        set(value) {
            field = value
            updateAdminTabView()
        }
    private fun onCheck() {
        onAutoUpdate(1)
    }
    private fun onDownload() {
        onAutoUpdate(2)
    }

    private fun onInstall() {
        onAutoUpdate(3)
    }
}

@Composable
fun AppUpdateAdminTabScreen(appUpdateAdminTabView: AdminTabView.AppUpdate) {
    LazyColumn(contentPadding = PaddingValues(horizontal = 30.dp, vertical = 10.dp)) {
        item {
            AdminText(
                buildAnnotatedString {
                    append( "버전:  ")
                    withStyle(SpanStyle(AdminManager.highlightTextColor)) {
                        append(appUpdateAdminTabView.version)
                    }
                }
            )

        }
        item {
            LazyRow(
                verticalAlignment = Alignment.CenterVertically,
                horizontalArrangement = Arrangement.spacedBy(10.dp)
            ) {
                if (appUpdateAdminTabView.isAutoUpdate) {
                    item {
                        CircularProgressIndicator()
                    }
                }
                item {
                    AdminText(appUpdateAdminTabView.autoUpdateText, color = AdminManager.highlightTextColor)
                }
                item {
                    AdminText(appUpdateAdminTabView.autoUpdateSubText, color = AdminManager.highlightTextColor)
                }
            }
        }
        item {
            LazyRow(
                verticalAlignment = Alignment.CenterVertically,
                horizontalArrangement = Arrangement.spacedBy(10.dp)
            ) {
                item {
                    if (appUpdateAdminTabView.isAutoUpdate && appUpdateAdminTabView.autoUpdateStep == 0) {
                        Button(
                            onClick = appUpdateAdminTabView.onCancelAutoUpdate,
                        ) {
                            AdminText("업데이트 (자동) 취소")
                        }
                    } else {
                        Button(
                            enabled = !appUpdateAdminTabView.isAutoUpdate,
                            onClick = appUpdateAdminTabView.onAutoUpdate,
                            colors = ButtonDefaults.buttonColors(disabledContainerColor = Color.Gray),
                        ) {
                            AdminText("업데이트 (자동)")
                        }
                    }
                }
            }
        }
        item {
            LazyRow(
                verticalAlignment = Alignment.CenterVertically,
                horizontalArrangement = Arrangement.spacedBy(10.dp)
            ) {
                item {
                    if (appUpdateAdminTabView.isAutoUpdate && appUpdateAdminTabView.autoUpdateStep == 1) {
                        Button(
                            onClick = appUpdateAdminTabView.onCancelAutoUpdate,
                        ) {
                            AdminText("업데이트 확인 취소")
                        }
                    } else {
                        Button(
                            enabled = !appUpdateAdminTabView.isAutoUpdate,
                            onClick = appUpdateAdminTabView.onCheck,
                            colors = ButtonDefaults.buttonColors(disabledContainerColor = Color.Gray),
                        ) {
                            AdminText("업데이트 확인")
                        }
                    }
                }
                item {
                    if (appUpdateAdminTabView.isAutoUpdate && appUpdateAdminTabView.autoUpdateStep == 2) {
                        Button(
                            onClick = appUpdateAdminTabView.onCancelAutoUpdate,
                        ) {
                            AdminText("다운로드 확인 취소")
                        }
                    } else {
                        Button(
                            enabled = appUpdateAdminTabView.isDownload && !appUpdateAdminTabView.isAutoUpdate,
                            onClick = appUpdateAdminTabView.onDownload,
                            colors = ButtonDefaults.buttonColors(disabledContainerColor = Color.Gray),
                        ) {
                            AdminText("다운로드 확인")
                        }
                    }
                }
                item {
                    if (appUpdateAdminTabView.isAutoUpdate && appUpdateAdminTabView.autoUpdateStep == 3) {
                        Button(
                            onClick = appUpdateAdminTabView.onCancelAutoUpdate,
                        ) {
                            AdminText("앱 설치 취소")
                        }
                    } else {
                        Button(
                            enabled = appUpdateAdminTabView.isInstall && !appUpdateAdminTabView.isAutoUpdate,
                            onClick = appUpdateAdminTabView.onInstall,
                            colors = ButtonDefaults.buttonColors(disabledContainerColor = Color.Gray),
                        ) {
                            AdminText("앱 설치 확인")
                        }
                    }
                }
            }
        }
    }
}
