package com.clobot.minibasic.data.admin

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.RowScope
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.Button
import androidx.compose.material3.ButtonDefaults
import androidx.compose.material3.DropdownMenu
import androidx.compose.material3.DropdownMenuItem
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.ExposedDropdownMenuBox
import androidx.compose.material3.ExposedDropdownMenuDefaults
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.AnnotatedString
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.TextUnit
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.clobot.minibasic.R
import com.clobot.minibasic.data.admin.tab.AppUpdateAdminTab
import com.clobot.minibasic.data.admin.tab.AppUpdateAdminTabScreen
import com.clobot.minibasic.data.admin.tab.EtcAdminTab
import com.clobot.minibasic.data.admin.tab.EtcAdminTabScreen
import com.clobot.minibasic.data.admin.tab.RobotAdminTab
import com.clobot.minibasic.data.admin.tab.RobotAdminTabScreen
import com.clobot.minibasic.data.admin.tab.OperationAdminTab
import com.clobot.minibasic.data.admin.tab.OperationTabScreen
import com.clobot.minibasic.data.admin.tab.ResourceUpdateAdminTab
import com.clobot.minibasic.data.admin.tab.ResourceUpdateAdminTabScreen
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.data.task.MiniBlackBg
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.TaskManager
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.view.layer5_admin.AdminTabListView
import com.clobot.minibasic.view.layer5_admin.AdminTabView
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update

abstract class AdminTab(private val adminManager: AdminManager) {
    abstract val name: String
    abstract val adminTabView: AdminTabView
    protected fun updateAdminTabView() {
        AdminManager.updateAdminTabView()
    }

    fun show() {
        onShow()
    }
    open fun onShow() {
    }
    fun hide() {
        onHide()
    }
    open fun onHide() {
    }

}

object AdminManager {

    private val adminTabList = mutableListOf<AdminTab>()
    private val adminTabListView: AdminTabListView
        get() {
            return AdminTabListView(
                onIsShow = { setIsShow(false) },
                adminTabList.toTypedArray(),
                selTab,
                onSelTab = { selTab = it })
        }

    private val selAdminTab: AdminTab?
        get() {
            return if (selTab >= 0 && selTab < adminTabList.size)
                adminTabList[selTab]
            else
                null
        }


    private var selTab = -1
        set(value) {
            field = value
            updateAdminTabListView()
            updateAdminTabView()
        }



    //private val operationScheduleAdminTab = OperationScheduleAdminTab(this)
    //private val operationSystemAdminTab = OperationSystemAdminTab(this)
    private val robotAdminTab = RobotAdminTab(this)
    private val operationAdminTab = OperationAdminTab(this)
    //private val modeAdminTab = ModeAdminTab(this)
    //private val dentalModeAdminTab = DentalModeAdminTab(this)
    //private val promoteModeAdminTab = PromoteModeAdminTab(this)
    private val appUpdateAdminTab = AppUpdateAdminTab(this)
    private val resourceUpdateAdminTab = ResourceUpdateAdminTab(this)
    private val etcAdminTab = EtcAdminTab(this)

    init {
        //adminTabList.add(operationScheduleAdminTab)
        //adminTabList.add(operationSystemAdminTab)
        //adminTabList.add(dentalModeAdminTab)
        //adminTabList.add(promoteModeAdminTab)
        //adminTabList.add(modeAdminTab)
        adminTabList.add(operationAdminTab)
        adminTabList.add(robotAdminTab)
        adminTabList.add(appUpdateAdminTab)
        adminTabList.add(resourceUpdateAdminTab)
        adminTabList.add(etcAdminTab)
    }



    private val isShowMsf = MutableStateFlow(false)

    val isShowSf = isShowMsf.asStateFlow()
    fun setIsShow(isShow: Boolean) {

        TaskManager.pause(TaskManager.Pause.User, isShow)

        if(isShow) {
            for(adminTab in adminTabList)
                adminTab.show()
        } else {
            for(adminTab in adminTabList)
                adminTab.hide()
        }

        isShowMsf.update {
            isShow
        }
    }

    private val adminTabListViewMsf = MutableStateFlow(adminTabListView)
    val adminTabListViewSf = adminTabListViewMsf.asStateFlow()
    private fun updateAdminTabListView() {
        adminTabListViewMsf.update {
            adminTabListView
        }
    }

    private val adminTabViewMsf = MutableStateFlow(selAdminTab?.adminTabView)
    val adminTabViewSf = adminTabViewMsf.asStateFlow()
    fun updateAdminTabView() {
        adminTabViewMsf.update {
            selAdminTab?.adminTabView
        }
    }

    val textColor = Color.White
    val highlightTextColor = Color.Yellow
    val warningTextColor = Color.Red
    val fontSize = 10.sp

}

@Composable
fun BaseAdminScreen(adminTabListView: AdminTabListView, contents: @Composable () -> Unit) {
    Surface(modifier = Modifier.fillMaxSize()) {
        MiniBlackBg {
            MiniImage(R.drawable.admin_back_btn,
                Modifier
                    .lp(20, 8, 96, 96)
                    .clickable { adminTabListView.onIsShow(false) })
            Box(Modifier.lp(10, 120, 350, MiniCompose.bg_height - 120 - 10)) {
                LazyColumn(content = {
                    items (count = adminTabListView.adminTabArr.size) {tab ->
                        Button(
                            modifier = Modifier.fillMaxWidth(),
                            enabled = adminTabListView.selTab != tab,
                            colors = ButtonDefaults.buttonColors(disabledContainerColor = Color.Gray),
                            onClick = { adminTabListView.onSelTab(tab) }
                        ) {
                            Text(adminTabListView.adminTabArr[tab].name, fontSize = 9.sp)
                        }
                    }
                })
            }
            Box(Modifier.lp(350, 120, MiniCompose.bg_width - 350 - 10, MiniCompose.bg_height - 120 - 10)) {
                contents()
            }
        }
    }
}

@Composable
fun AdminTabScreen(adminTabView: AdminTabView?) {
    if (adminTabView == null)
        return
    when (adminTabView) {
        //is AdminTabView.OperationSchedule -> OperationScheduleAdminTabScreen(adminTabView)
        //is AdminTabView.OperationSystem -> OperationSystemAdminTabScreen(adminTabView)
        is AdminTabView.Robot -> RobotAdminTabScreen(adminTabView)
        is AdminTabView.Operation -> OperationTabScreen(adminTabView)
        //is AdminTabView.Mode -> ModeAdminTabScreen(adminTabView)
        //is AdminTabView.DentalMode -> DentalModeAdminTabScreen(adminTabView)
        //is AdminTabView.PromoteMode -> PromoteModeAdminTabScreen(adminTabView)
        is AdminTabView.AppUpdate -> AppUpdateAdminTabScreen(adminTabView)
        is AdminTabView.ResourceUpdate -> ResourceUpdateAdminTabScreen(adminTabView)
        is AdminTabView.Etc -> EtcAdminTabScreen(adminTabView)
    }
}

@Composable
fun AdminText(text: AnnotatedString, color: Color = AdminManager.textColor, fontSize: TextUnit = AdminManager.fontSize) {
    Text(text, color = color, fontSize = fontSize)
}

@Composable
fun AdminText(text: String, color: Color = AdminManager.textColor, fontSize: TextUnit = AdminManager.fontSize) {
    Text(text, color = color, fontSize = fontSize)
}
@Composable
fun AdminSmallText(text: String, color: Color = Color.LightGray, fontSize: TextUnit = 8.sp) {
    Text(text, color = color, fontSize = fontSize, textAlign = TextAlign.Center)
}

@Composable
fun AdminButton(onClick: () -> Unit, width: Dp = 50.dp, height: Dp = 32.dp, content: @Composable RowScope.() -> Unit) {
    Button(onClick, modifier = Modifier.width(width).height(height), content = content)
}

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun AdminSpinner(
    index: Int,
    options: List<String>,
    onSelected: (Int) -> Unit
) {

    var expanded by remember { mutableStateOf(false) }
    var selectedOptionText by remember { mutableStateOf(options[index]) }

    ExposedDropdownMenuBox(
        expanded = expanded,
        onExpandedChange = {
            expanded = !expanded
        }
    ) {
        Button(modifier = Modifier.menuAnchor(), onClick = {expanded = true}) {
            Text(selectedOptionText)
        }
        DropdownMenu(
            expanded = expanded,
            onDismissRequest = {
                expanded = false
            }
        ) {
            options.forEachIndexed { index: Int, selectionOption: String ->
                DropdownMenuItem(
                    text = {
                        Text(text = selectionOption)
                    },
                    onClick = {
                        selectedOptionText = selectionOption
                        expanded = false
                        onSelected(index)
                    },
                    contentPadding = ExposedDropdownMenuDefaults.ItemContentPadding,
                )
            }
        }
    }
}
