package com.clobot.minibasic.data

object SetupManger {

    class Robot {
        companion object {
            private const val CLASS_NAME = "SetupManger::Robot::"

            private const val START_NAVIGATION_TIMEOUT_SEC_KEY = CLASS_NAME + "startNavigationTimeoutSec"
            var startNavigationTimeoutSec = ProfileManager.getPutInt(START_NAVIGATION_TIMEOUT_SEC_KEY, 20)
                set(value) {
                    ProfileManager.putInt(START_NAVIGATION_TIMEOUT_SEC_KEY, value)
                    field = value
                }

            private const val START_NAVIGATION_LINEAR_SPEED_KEY = CLASS_NAME + "startNavigationLinearSpeed"
            var startNavigationLinearSpeed =
                ProfileManager.getPutFloat(START_NAVIGATION_LINEAR_SPEED_KEY, 0.7f)
                set(value) {
                    ProfileManager.putFloat(START_NAVIGATION_LINEAR_SPEED_KEY, value)
                    field = value
                }

            private const val START_NAVIGATION_ANGULAR_SPEED_KEY = CLASS_NAME + "startNavigationAngularSpeed"
            var startNavigationAngularSpeed =
                ProfileManager.getPutFloat(START_NAVIGATION_ANGULAR_SPEED_KEY, 1.0f)
                set(value) {
                    ProfileManager.putFloat(START_NAVIGATION_ANGULAR_SPEED_KEY, value)
                    field = value
                }

            const val playTextLowVolume = 0.5f
            const val playTextMediumVolume = 0.1f
            const val playTextHighVolume = 0.5f

        }
    }


    class Init {
        companion object {
            var initTryMaxCount = 3

            var initShowFailSceneTimeoutSec = 3
        }
    }

    class Open {

        companion object {
            var showChangeModeSceneTimeoutSec = 5
        }

        class Move {
            companion object {
                var initPosPoi = "초기위치"
                var leaveChargePileSpeed = 0.1f
                var leaveChargePileDistance = 0.2f

                var leaveStartSceneTimeoutSec = 10
                var leaveShowStartSceneTimeoutSec = 3
                var leaveShowFailSceneTimeoutSec = 5
                var leaveShowFailSceneTryCountMax = 3

                var navigationShowStartSceneTimeoutSec = 3
                var navigationStartSceneTimeoutSec = 3 * 60
                var navigationShowFailSceneTimeoutSec = 5
                var navigationShowFailSceneTryCountMax = 3

            }
        }
    }
    class Rest {

        companion object {
            var restShowCloseSceneTimeoutSec = 5
        }
        class Charge {
            companion object {

                var startChargeTimeoutSec = 20

                var chargeShowStartSceneTimeoutSec = 3
                var chargeStartSceneTimeoutSec = 60
                var chargeShowFailSceneTryCountMax = 3
                var chargeShowFailSceneTimeoutSec = 5
            }
        }
    }
}