package com.clobot.minibasic.data

import android.content.Context
import android.content.SharedPreferences

object ProfileManager {

    private lateinit var _sharedPref: SharedPreferences

    fun init(context: Context, name: String) {
        _sharedPref = context.getSharedPreferences(name, Context.MODE_PRIVATE)
    }

    fun getString(key: String, defaultValue: String): String {
        return _sharedPref.getString(key, defaultValue).toString()
    }
    fun putString(key: String, value: String) {
        val edit = _sharedPref.edit()
        edit.putString(key, value)
        edit.apply()
    }
    fun getPutString(key: String, defaultValue: String): String {
        val value = getString(key, defaultValue)
        putString(key, value)
        return value
    }

    fun getPutBoolean(key: String, defaultValue: Boolean): Boolean {
        val value = getBoolean(key, defaultValue)
        putBoolean(key, value)
        return value
    }
    fun getBoolean(key: String, defaultValue: Boolean): Boolean {
        return _sharedPref.getBoolean(key, defaultValue)
    }
    fun putBoolean(key: String, value: Boolean) {
        val edit = _sharedPref.edit()
        edit.putBoolean(key, value)
        edit.apply()
    }
    fun getInt(key: String, defaultValue: Int): Int {
        return _sharedPref.getInt(key, defaultValue)
    }
    fun putInt(key: String, value: Int) {
        val edit = _sharedPref.edit()
        edit.putInt(key, value)
        edit.apply()
    }
    fun getPutInt(key: String, defaultValue: Int): Int {
        val value = getInt(key, defaultValue)
        putInt(key, value)
        return value
    }

    fun getFloat(key: String, defaultValue: Float): Float {
        return _sharedPref.getFloat(key, defaultValue)
    }
    fun putFloat(key: String, value: Float) {
        val edit = _sharedPref.edit()
        edit.putFloat(key, value)
        edit.apply()
    }
    fun getPutFloat(key: String, defaultValue: Float): Float {
        val value = getFloat(key, defaultValue)
        putFloat(key, value)
        return value
    }
    
}
