package com.clobot.minibasic.data

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import com.clobot.minibasic.data.admin.AdminManager
import com.clobot.minibasic.data.devel.DevelManager
import com.clobot.minibasic.data.task.MiniCompose
import com.clobot.minibasic.data.task.lp
import com.clobot.minibasic.view.layer6_hidden.HiddenView
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update

object HiddenManager {

    private const val CLASS_NAME = "HiddenManager::"


    private const val IS_DEVEL_BUTTON_SHOW_KEY = CLASS_NAME + "isDevelButtonShow"
    var isDevelButtonShow: Boolean = ProfileManager.getPutBoolean(IS_DEVEL_BUTTON_SHOW_KEY, false)
        set(value) {
            ProfileManager.putBoolean(IS_DEVEL_BUTTON_SHOW_KEY, value)
            field = value
            hiddenViewMsf.update { hiddenView }
        }

    private val hiddenView: HiddenView
        get() {
            return HiddenView(
                onAdmin = { AdminManager.setIsShow(true) },
                isDevelButtonShow,
                onDevel = { DevelManager.setIsShow(true) },
            )
        }

    private val hiddenViewMsf = MutableStateFlow(hiddenView)
    val hiddenViewSf = hiddenViewMsf.asStateFlow()
}

@Composable
fun BaseHiddenScreen(contents: @Composable () -> Unit) {
    Box(
        modifier = Modifier.fillMaxSize(),
    ) {
        contents()
    }
}


@Composable
fun HiddenScreen(hiddenView: HiddenView) {
    val buttonWidth = 200
    val buttonHeight = 100
    Box(Modifier.lp(MiniCompose.bg_center_x - buttonWidth / 2, 1, buttonWidth, buttonHeight).clickable { hiddenView.onAdmin() })
    if (hiddenView.isDevelButtonShow)
        Box(Modifier.lp(MiniCompose.bg_width - buttonWidth - 1, MiniCompose.bg_height - buttonHeight - 1, buttonWidth, buttonHeight).clickable { hiddenView.onDevel() })
}
