package com.clobot.minibasic.data

import androidx.compose.animation.animateColor
import androidx.compose.animation.core.RepeatMode
import androidx.compose.animation.core.infiniteRepeatable
import androidx.compose.animation.core.rememberInfiniteTransition
import androidx.compose.animation.core.tween
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.Surface
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.BlendMode
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.ColorFilter
import com.clobot.minibasic.R
import com.clobot.minibasic.data.task.MiniImage
import com.clobot.minibasic.data.task.MiniImageBg
import com.clobot.minibasic.data.task.lp
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update
import kotlinx.coroutines.launch

object EmergencyManager {
    private val isShowMsf = MutableStateFlow(false)
    val isShowSf = isShowMsf.asStateFlow()

    init {
        MainScope().launch {
            RobotManager.isEmergencySf.collect() { isEmergency ->
                isShowMsf.update {
                    isEmergency == true
                }
            }
        }
    }
}

@Composable
fun EmergencyScreen() {
    Surface(modifier = Modifier.fillMaxSize(), color = Color.Black) {
        MiniImageBg(R.drawable.emergency_bg) {
            val infiniteTransition = rememberInfiniteTransition(label = "")
            val animatedColor by infiniteTransition.animateColor(
                initialValue = Color(0xffff3030),
                targetValue = Color(0x000000),
                animationSpec = infiniteRepeatable(tween(500), RepeatMode.Restart),
                label = ""
            )
            MiniImage(R.drawable.emergency_text, Modifier.lp(575, 349, 768, 172),
                colorFilter = ColorFilter.tint(animatedColor, blendMode = BlendMode.Darken))
        }
    }
}
