package com.clobot.minibasic.data

import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.asStateFlow
import kotlinx.coroutines.flow.update
import java.time.LocalDateTime
import java.time.LocalTime
import kotlin.concurrent.timer

object ClockManager {

    private val _dateTimeSf = MutableStateFlow(LocalDateTime.now())
    val dateTimeSf = _dateTimeSf.asStateFlow()

    init {
        timer(period = 1000L, initialDelay = 1000L) {
            _dateTimeSf.update {
                LocalDateTime.now()
            }
        }
    }

}