package com.clobot.minibasic

import DevelVM
import android.Manifest
import android.content.pm.ActivityInfo
import android.content.pm.PackageManager
import android.os.Bundle
import android.util.Log
import android.widget.Toast
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import androidx.lifecycle.lifecycleScope
import androidx.lifecycle.viewmodel.compose.viewModel
import com.clobot.minibasic.data.BaseHiddenScreen
import com.clobot.minibasic.data.EmergencyScreen
import com.clobot.minibasic.data.HiddenScreen
import com.clobot.minibasic.data.ProfileManager
import com.clobot.minibasic.data.admin.AdminTabScreen
import com.clobot.minibasic.data.admin.BaseAdminScreen
import com.clobot.minibasic.data.caption.BaseCaptionScreen
import com.clobot.minibasic.data.caption.CaptionScreen
import com.clobot.minibasic.data.devel.BaseDevelScreen
import com.clobot.minibasic.data.devel.DevelManager
import com.clobot.minibasic.data.devel.DevelTabScreen
import com.clobot.minibasic.data.popup.BasePopupScreen
import com.clobot.minibasic.data.popup.PopupScreen
import com.clobot.minibasic.data.task.BaseSceneScreen
import com.clobot.minibasic.view.layer5_admin.AdminVM
import com.clobot.minibasic.view.layer6_hidden.HiddenVM
import com.clobot.minibasic.data.task.TaskManager
import com.clobot.minibasic.data.task.MiniTask
import com.clobot.minibasic.data.task.SceneScreen
import com.clobot.minibasic.data.update.ResourceUpdateManager
import com.clobot.minibasic.data.update.UpdateManager
import com.clobot.minibasic.view.layer1_scene.SceneVM
import com.clobot.minibasic.view.layer2_caption.CaptionVM
import com.clobot.minibasic.view.layer4_emergency.EmergencyVM
import com.clobot.minibasic.view.layer3_popup.PopupVM
import kotlinx.coroutines.CoroutineName
import kotlinx.coroutines.launch

class MainActivity : ComponentActivity() {

    private val requiredPermissions =
        arrayOf(
            Manifest.permission.READ_EXTERNAL_STORAGE,
            Manifest.permission.WRITE_EXTERNAL_STORAGE,
        )

    private fun isAllPermissionsGranted() = requiredPermissions.all {
        ContextCompat.checkSelfPermission(
            baseContext, it
        ) == PackageManager.PERMISSION_GRANTED
    }

    @Deprecated("Deprecated in Java")
    override fun onRequestPermissionsResult(
        requestCode: Int, permissions: Array<String>, grantResults:
        IntArray
    ) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
        if (requestCode == REQUEST_CODE_PERMISSIONS) {
            // 카메라 권한의 경우, 미니에서는 앱 권한 설정 대화상자의 카메라 권한을 [허용]을 누르면 앱은 권한을 얻게 되고, 앱이 바로 종료가 된다.
            // (다른 기기에서는 이렇게 앱이 종료 되지는 않는데 미니에는 이렇게 되는 것 같음) 그래서, 앱을 한번 더 실행해야 한다.
            if (grantResults.isNotEmpty()) {
                if (!isAllPermissionsGranted()) {
                    Toast.makeText(
                        this,
                        "앱 실행에 필요한 필요 권한을 획득하지 못 했습니다.",
                        Toast.LENGTH_LONG
                    ).show()
                    finish()
                }
            }

        }
    }
    companion object {
        private const val REQUEST_CODE_PERMISSIONS = 10
    }



    override fun onPause() {
        super.onPause()

        TaskManager.pause(TaskManager.Pause.Activity, true)

        DevelManager.generalDevelTab.log("MainActivity::onPause()")
    }
    override fun onResume() {
        super.onResume()

        TaskManager.pause(TaskManager.Pause.Activity, false)

        DevelManager.generalDevelTab.log("MainActivity::onResume()")

    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        // full screen 을 위해서는 themes.xml에
        //<style> <item name="android:windowFullscreen">true</item>item> </style>
        // 추가해 줘야함
        requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE

        Log.d(MainActivity::class.java.simpleName, "======================")

        DevelManager.generalDevelTab.log("MainActivity::onCreate()")

        if (BuildConfig.isRobot) {
            resources.displayMetrics.widthPixels = 1920
            resources.displayMetrics.heightPixels = 1080
        }

        if (!isAllPermissionsGranted()) {
            ActivityCompat.requestPermissions(
                this, requiredPermissions,
                Companion.REQUEST_CODE_PERMISSIONS
            )
        }

        ProfileManager.init(this, resources.getString(R.string.app_name))
        UpdateManager.init(this)
        ResourceUpdateManager.init(this)

        if (TaskManager.taskCoroutineScope == null) {
            lifecycleScope.launch(CoroutineName("task")) {
                TaskManager.taskCoroutineScope = this
                MiniTask(this@MainActivity).run()
            }
        }


        setContent {
            val sceneVM: SceneVM = viewModel()
            BaseSceneScreen {
                SceneScreen(sceneVM.sceneView)
            }

            val captionVM: CaptionVM = viewModel()
            if (captionVM.isShow) {
                BaseCaptionScreen {
                    CaptionScreen(captionVM.captionView)
                }
            }


            val popupVM: PopupVM = viewModel()
            if (popupVM.isShow) {
                BasePopupScreen {
                    PopupScreen(popupVM.popupView)
                }
            }

            val emergencyVM: EmergencyVM = viewModel()
            if (emergencyVM.isShow) {
                EmergencyScreen()
            }

            val adminVM: AdminVM = viewModel()
            if (adminVM.isShow) {
                BaseAdminScreen(adminVM.adminTabListView) {
                    AdminTabScreen(adminVM.adminTabView)
                }
            }

            val hiddenVM: HiddenVM = viewModel()
            BaseHiddenScreen {
                HiddenScreen(hiddenVM.hiddenView)
            }

            val develVM: DevelVM = viewModel()
            if (develVM.isShow) {
                BaseDevelScreen(develVM.develTabListView) {
                    DevelTabScreen(develVM.develTabView)
                }
            }
        }
    }
}
