plugins {
    id("com.android.application")
    id("org.jetbrains.kotlin.android")
}

android {
    namespace = "com.clobot.minibasic"
    compileSdk = 34

    defaultConfig {
        applicationId = "com.clobot.minibasic"
        minSdk = 28
        targetSdk = 34
        versionCode = 1
        versionName = "0.08.003"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
        vectorDrawables {
            useSupportLibrary = true
        }

        buildConfigField("boolean", "isRobot", "true")
        buildConfigField("boolean", "isPersonNullTest", "false")
    }

    buildTypes {
        release {
            isMinifyEnabled = false
            proguardFiles(
                getDefaultProguardFile("proguard-android-optimize.txt"),
                "proguard-rules.pro"
            )
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_1_8
        targetCompatibility = JavaVersion.VERSION_1_8
    }
    kotlinOptions {
        jvmTarget = "1.8"
    }
    buildFeatures {
        compose = true
        buildConfig = true // BuildConfig 사용 가능
    }
    composeOptions {
        kotlinCompilerExtensionVersion = "1.5.1"
    }
    packaging {
        resources {
            excludes += "/META-INF/{AL2.0,LGPL2.1}"
        }
    }
}

dependencies {

    implementation("androidx.core:core-ktx:1.13.1")
    implementation("androidx.lifecycle:lifecycle-runtime-ktx:2.7.0")
    implementation("androidx.activity:activity-compose:1.9.0")
    implementation(platform("androidx.compose:compose-bom:2023.08.00"))
    implementation("androidx.compose.ui:ui")
    implementation("androidx.compose.ui:ui-graphics")
    implementation("androidx.compose.ui:ui-tooling-preview")
    implementation("androidx.compose.material3:material3")
    implementation(files("libs\\robotservice.jar"))
    testImplementation("junit:junit:4.13.2")
    androidTestImplementation("androidx.test.ext:junit:1.1.5")
    androidTestImplementation("androidx.test.espresso:espresso-core:3.5.1")
    androidTestImplementation(platform("androidx.compose:compose-bom:2023.08.00"))
    androidTestImplementation("androidx.compose.ui:ui-test-junit4")
    debugImplementation("androidx.compose.ui:ui-tooling")
    debugImplementation("androidx.compose.ui:ui-test-manifest")

    implementation("com.google.code.gson:gson:2.9.1") // 필수 !! 없으면 RobotApi.getInstance() 호출시 크레시

    implementation("androidx.lifecycle:lifecycle-viewmodel-compose:2.6.2")   // compose 안에서 ViewModel 을 참조 가능.

    implementation("com.github.skydoves:landscapist-coil:1.4.7") // CoilImage

    implementation("commons-net:commons-net:3.9.0") // ftp

    implementation("com.squareup.retrofit2:retrofit:2.9.0")         // download
    implementation("com.squareup.retrofit2:converter-gson:2.9.0")   // download
    implementation("com.squareup.retrofit2:converter-moshi:2.9.0")  // download

}