/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import com.ainirobot.coreservice.utils.IOUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.util.Properties;

public class Utils {
    public static void writeIpProp(Context context) {
        Properties prop = new Properties();
        prop.put("NaviIp", "192.168.0.17");
        Utils.saveConfig(context, "/mnt/sdcard/config.properties", prop);
    }

    public static boolean saveConfig(Context context, String file, Properties properties) {
        try {
            File fil = new File(file);
            if (!fil.exists()) {
                fil.createNewFile();
            }
            FileOutputStream s = new FileOutputStream(fil);
            properties.store(s, "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getIpProp(Context context) {
        Properties prop = Utils.loadConfig(context, "/mnt/sdcard/config.properties");
        return prop.getProperty("NaviIp");
    }

    public static Properties loadConfig(Context context, String file) {
        Properties properties = new Properties();
        try {
            FileInputStream s = new FileInputStream(file);
            properties.load(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadConfig(Context context, String testFile, int rawFile) {
        InputStream is = null;
        try {
            File file = new File(testFile);
            is = file.exists() ? new FileInputStream(file) : context.getResources().openRawResource(rawFile);
            int total = is.available();
            byte[] bytes = new byte[total];
            int len = is.read(bytes);
            if (total == len) {
                String string = new String(bytes);
                IOUtils.close(is);
                return string;
            }
            IOUtils.close(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.close(is);
        }
        return null;
    }

    public static boolean removeFileFromSDCard(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            try {
                file.delete();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String getFileContent(String filePath) {
        File file = new File(filePath);
        String str = "";
        StringBuffer content = new StringBuffer();
        FileInputStream is = null;
        InputStreamReader input = null;
        BufferedReader reader = null;
        try {
            is = new FileInputStream(file);
            input = new InputStreamReader((InputStream)is, "UTF-8");
            reader = new BufferedReader(input);
            while ((str = reader.readLine()) != null) {
                content.append(str);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            IOUtils.close(is);
            IOUtils.close(input);
            IOUtils.close(reader);
            return content.toString();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            {
                catch (Throwable throwable) {
                    IOUtils.close(is);
                    IOUtils.close(input);
                    IOUtils.close(reader);
                    return content.toString();
                }
            }
            IOUtils.close(is);
            IOUtils.close(input);
            IOUtils.close(reader);
            return content.toString();
        }
        IOUtils.close(is);
        IOUtils.close(input);
        IOUtils.close(reader);
        return content.toString();
    }

    public static String getPackageSign(Context context, String pkgName) {
        String signStr = "-1";
        PackageManager packageManager = context.getPackageManager();
        Signature[] signatures = null;
        try {
            PackageInfo packageInfo = packageManager.getPackageInfo(pkgName, 64);
            signatures = packageInfo.signatures;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != signatures && signatures.length > 0) {
            Signature sign = signatures[0];
            signStr = Utils.encryptionMD5(sign.toByteArray()).toUpperCase();
        }
        return signStr;
    }

    private static String encryptionMD5(byte[] byteStr) {
        StringBuilder md5StrBuff = new StringBuilder();
        try {
            byte[] byteArray;
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(byteStr);
            for (byte aByteArray : byteArray = messageDigest.digest()) {
                if (Integer.toHexString(0xFF & aByteArray).length() == 1) {
                    md5StrBuff.append("0").append(Integer.toHexString(0xFF & aByteArray));
                    continue;
                }
                md5StrBuff.append(Integer.toHexString(0xFF & aByteArray));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return md5StrBuff.toString();
    }
}

