/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.utils;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.provider.Settings;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.Log;

public class SettingDataHelper {
    private static final String TAG = SettingDataHelper.class.getSimpleName();
    private static final String URI = "content://com.ainirobot.coreservice.robotsettingprovider/setting";
    private static final String KEY_ID = "id";
    private static final String KEY_VALUE = "value";
    private static final String AUTH_URI = "content://com.ainirobot.coreservice.AuthProvider/AuthInfo";
    private static final String PKG_NAME = "pkgName";
    private static final String PKG_SIGN = "pkgSign";
    private static final String APP_ID = "appId";
    private static final String IS_AUTH = "isAuth";
    public static final String BOOT_APP_PACKAGE_NAME = "boot_app_package_name";
    public static final String BOSS_AVATAR_ON_MOBILE = "boss_avatar_on_mobile";
    public static final String BUILD_NEW_MAP_ON_MOBILE = "build_new_map_on_mobile";
    public static final String CHARGING_PILE_CONFIGURED = "charging_pile_configured";
    public static final String ROBOT_AUTO_BACK_RECEPTION = "robot_auto_back_reception";
    public static final String ROBOT_CHAT_REPLY = "robot_chat_reply";
    public static final String ROBOT_DROPDOWN_BAR_PASSWORD = "robot_dropdown_bar_password";
    public static final String ROBOT_FOCUS_FOLLOW = "robot_focus_follow";
    public static final String ROBOT_MASK_DETECTION = "robot_mask_detection";
    public static final String ROBOT_REGULAR_CHARGE_TIME_LIST = "robot_regular_charge_time_list";
    public static final String ROBOT_OBSTACLES_AVOID = "robot_obstacles_avoid";
    public static final String ROBOT_PREVENT_COLLISION = "robot_prevent_collision";
    public static final String ROBOT_SMALL_ACTION = "robot_samll_action";
    public static final String ROBOT_SETTING_ALLOW_AUTO_SITU_SERVICE = "robot_setting_allow_auto_situ_service";
    public static final String ROBOT_SETTING_AUTO_CHARGE = "robot_setting_auto_charge";
    public static final String ROBOT_SETTING_CRUISE_ANGULAR_SPEED = "robot_setting_cruise_angular_speed";
    public static final String ROBOT_SETTING_CRUISE_LINEAR_SPEED = "robot_setting_cruise_linear_speed";
    public static final String ROBOT_SETTING_DISABLE_VOICE_CONTROL_VOLUME = "robot_setting_disable_voice_control_volume";
    public static final String ROBOT_SETTING_GREET_ANGULAR_SPEED = "robot_setting_greet_angular_speed";
    public static final String ROBOT_SETTING_GREET_LINEAR_SPEED = "robot_setting_greet_linear_speed";
    public static final String ROBOT_SETTING_GUIDE_ANGULAR_SPEED = "robot_setting_guide_angular_speed";
    public static final String ROBOT_SETTING_GUIDE_LINEAR_SPEED = "robot_setting_guide_linear_speed";
    public static final String ROBOT_SETTING_HIDE_MANUFACTURE_INFORMATION = "robot_setting_hide_manufacture_information";
    public static final String ROBOT_SETTING_LEAD_ANGULAR_SPEED = "robot_setting_lead_angular_speed";
    public static final String ROBOT_SETTING_LEAD_LINEAR_SPEED = "robot_setting_lead_linear_speed";
    public static final String ROBOT_SETTING_NAV_ANGULAR_SPEED = "robot_setting_nav_angular_speed";
    public static final String ROBOT_SETTING_NAV_LINEAR_SPEED = "robot_setting_nav_linear_speed";
    public static final String ROBOT_SETTING_OTA_UPDATE = "robot_setting_ota_update";
    public static final String ROBOT_SETTING_SHIPPING_MODE = "robot_setting_shipping_mode";
    public static final String ROBOT_SETTING_SITU_SERVICE_RUNNING_TIME = "robot_setting_situ_service_running_time";
    public static final String ROBOT_SETTING_SITU_SERVICE_STATUS = "robot_setting_situ_service_status";
    public static final String ROBOT_SETTING_SITU_SERVICE_TIME = "robot_setting_situ_service_time";
    public static final String ROBOT_SETTING_SOUND_ANGEL_CENTER = "robot_setting_sound_angel_center";
    public static final String ROBOT_SETTING_SOUND_ANGEL_RANGE = "robot_setting_sound_angel_range";
    public static final String ROBOT_SETTING_SPEECH_SPEED = "robot_setting_speech_speed";
    public static final String ROBOT_SETTING_SPOKE_MAN = "robot_setting_spoke_man";
    public static final String ROBOT_SETTING_VAD_END = "robot_setting_vad_end";
    public static final String ROBOT_SETTING_WAITING_TIME = "robot_setting_waiting_time";
    public static final String ROBOT_SETTINGS_CHARGING_ENVIRONMENT = "robot_settings_charging_environment";
    public static final String ROBOT_SETTINGS_OBSTACLES_AVOID_DISTANCE = "robot_settings_obstacles_avoid_distance";
    public static final String ROBOT_SHOW_AD = "robot_show_ad";
    public static final String ROBOT_SHOW_AD_AND_ROTATE = "robot_show_ad_and_rotate";
    public static final String ROBOT_USABLE_WHEN_CHARGING = "robot_usable_when_charging";
    public static final String SETTINGS_GLOBAL_SWITCH_FOLLOW_STYLE = "settings_global_switch_follow_style";
    public static final String SLEEP_LIST = "sleep_list";
    public static final String SWITCH_ALLOW_CHAT_WHEN_INTERPRET = "switch_allow_chat_when_interpret";
    public static final String SWITCH_START_APP_PASSWORD = "switch_start_app_password";
    public static final String VERSION_UPGRADE_ON_MOBILE = "version_upgrade_on_mobile";
    public static final String ROBOT_LANGUAGE = "robot_language";
    public static final String ROBOT_TIME_ZONE_CODE = "robot_time_zone_code";
    public static final String ROBOT_SETTING_SYSTEM_ENV = "robot_setting_system_environment";
    public static final String ROBOT_SETTING_SYSTEM_ADB_ALWAYS_OPEN = "robot_setting_system_adb_always_open";
    public static final String ROBOT_SETTING_SPEAKER_ROLE = "robot_setting_speaker_role";
    public static final String ROBOT_SETTING_PRODUCT_TYPE = "robot_product_type";
    public static final String ROBOT_SETTING_ENABLE_ASR_SWITCH = "robot_enable_asr_switch";
    public static final String ROBOT_SETTING_PORTAL_OPK = "robot_portal_opk";
    public static final String ROBOT_SETTINGS_CLOUD_SERVER_ZONE = "robot_settings_cloud_server_zone";
    public static final String ROBOT_SETTING_STANDBY_OPK_MODE_SWITCH = "robot_setting_standby_opk_mode";
    public static final String ROBOT_SETTING_RADAR_ENABLE_IN_STADNBY_SWITCH = "robot_setting_radar_enable_in_standby";
    public static final String GLOBAL_ADMIN_FULL_NAME = "admin_full_name";
    public static final String GLOBAL_ADMIN_MOBILE = "admin_mobile";
    public static final String GLOBAL_CORP_NAME = "corp_name";
    public static final String GLOBAL_CORP_UUID = "corp_uuid";
    public static final String GLOBAL_DEVICE_PROVISIONED = "device_provisioned";
    public static final String GLOBAL_HOME_LAUNCHER_COMPONENT = "robot_setting_home_launcher_component";
    public static final String GLOBAL_REGULAR_CHARGE_TIME_SPAN_MAX_COUNT = "robot_regular_charge_time_span_max_count";
    public static final String GLOBAL_ROBOT_NAME = "robot_name";
    public static final String GLOBAL_ROBOT_SAMPLE = "robot_sample";
    public static final String GLOBAL_ROBOT_UUID = "robot_uuid";
    public static final String GLOBAL_SHUT_DOWN_PASSWORD = "robot_shut_down_password";
    public static final String GLOBAL_MEAL_DELIVERY_THREE_FLOORS = "robot_meal_delivery_three_floors";
    public static final String ROBOT_SETTING_QUICK_SETTING_BAR_SUPPORT_METHOD = "robot_settings_quick_setting_bar_support_method";
    public static final String SYSTEM_SCREEN_BRIGHTNESS = "screen_brightness";
    public static final String SYSTEM_SCREEN_BRIGHTNESS_MODE = "screen_brightness_mode";
    public static final int SYSTEM_SCREEN_BRIGHTNESS_MODE_AUTOMATIC = 1;
    public static final int SYSTEM_SCREEN_BRIGHTNESS_MODE_MANUAL = 0;
    public static final String SYSTEM_VOLUME_MUSIC_SPEAKER = "volume_music_speaker";
    public static final String ACTION_MANAGE_OVERLAY_PERMISSION = "android.settings.action.MANAGE_OVERLAY_PERMISSION";
    public static final String ACTION_MANAGE_WRITE_SETTINGS = "android.settings.action.MANAGE_WRITE_SETTINGS";
    private static SettingDataHelper mInstance;
    private static Context mContext;

    public static synchronized SettingDataHelper getInstance() {
        if (mInstance == null) {
            mInstance = new SettingDataHelper();
        }
        return mInstance;
    }

    public void setContext(Context context) {
        mContext = context;
        Log.i((String)TAG, (String)"set context");
    }

    private SettingDataHelper() {
        Log.i((String)TAG, (String)"create");
    }

    public int getRobotInt(String key) {
        String value = this.getRobotString(key);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return -1;
        }
        return Integer.valueOf(value);
    }

    public float getRobotFloat(String key) {
        String value = this.getRobotString(key);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return -1.0f;
        }
        return Float.valueOf(value).floatValue();
    }

    public long getRobotLong(String key) {
        String value = this.getRobotString(key);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return -1L;
        }
        return Long.valueOf(value);
    }

    public String getRobotString(String key) {
        Cursor cursor;
        String result = "";
        if (mContext != null && (cursor = mContext.getContentResolver().query(Uri.parse((String)URI), new String[]{KEY_VALUE}, "id=?", new String[]{key}, null)) != null && cursor.moveToNext()) {
            result = cursor.getString(cursor.getColumnIndex(KEY_VALUE));
            cursor.close();
        }
        if (!TextUtils.isEmpty((CharSequence)result)) {
            return result;
        }
        result = Settings.Global.getString((ContentResolver)mContext.getContentResolver(), (String)key);
        if (TextUtils.isEmpty((CharSequence)result)) {
            result = "";
        }
        return result;
    }

    public int getGlobalInt(String key, int defaultValue) {
        return Settings.Global.getInt((ContentResolver)mContext.getContentResolver(), (String)key, (int)defaultValue);
    }

    public String getGlobalString(String key) {
        return Settings.Global.getString((ContentResolver)mContext.getContentResolver(), (String)key);
    }

    public int getSecureInt(String key, int defaultValue) {
        return Settings.Secure.getInt((ContentResolver)mContext.getContentResolver(), (String)key, (int)defaultValue);
    }

    public String getSecureString(String key) {
        return Settings.Secure.getString((ContentResolver)mContext.getContentResolver(), (String)key);
    }

    public int getSystemInt(String key, int defaultValue) {
        return Settings.System.getInt((ContentResolver)mContext.getContentResolver(), (String)key, (int)defaultValue);
    }

    public float getSystemFloat(String key, float defaultValue) {
        return Settings.System.getFloat((ContentResolver)mContext.getContentResolver(), (String)key, (float)defaultValue);
    }

    public void putRobotInt(String key, int value) {
        this.putRobotString(key, String.valueOf(value));
    }

    public void putRobotFloat(String key, float value) {
        this.putRobotString(key, String.valueOf(value));
    }

    public void putRobotLong(String key, long value) {
        this.putRobotString(key, String.valueOf(value));
    }

    public void putRobotString(String key, String value) {
        ContentValues contentValues = new ContentValues();
        contentValues.put(KEY_VALUE, value);
        try {
            mContext.getContentResolver().update(Uri.parse((String)URI), contentValues, "id=?", new String[]{key});
        }
        catch (IllegalArgumentException e) {
            Log.d((String)TAG, (String)"unSupport uri");
        }
    }

    public void putGlobalInt(String key, int value) {
        Settings.Global.putInt((ContentResolver)mContext.getContentResolver(), (String)key, (int)value);
    }

    public void putSecureInt(String key, int value) {
        Settings.Secure.putInt((ContentResolver)mContext.getContentResolver(), (String)key, (int)value);
    }

    public void putSecureString(String key, String value) {
        Settings.Secure.putString((ContentResolver)mContext.getContentResolver(), (String)key, (String)value);
    }

    public void putSystemInt(String key, int value) {
        Settings.System.putInt((ContentResolver)mContext.getContentResolver(), (String)key, (int)value);
    }

    public void putSystemFloat(String key, float value) {
        Settings.System.putFloat((ContentResolver)mContext.getContentResolver(), (String)key, (float)value);
    }

    public Uri getRobotUriFor(String key) {
        return Uri.withAppendedPath((Uri)Uri.parse((String)URI), (String)key);
    }

    public Uri getGlobalUriFor(String key) {
        return Settings.Global.getUriFor((String)key);
    }

    public void registerRobotContentObserver(String key, ContentObserver observer) {
        mContext.getContentResolver().registerContentObserver(this.getRobotUriFor(key), false, observer);
    }

    public void registerSystemContentObserver(String key, ContentObserver observer) {
        mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor((String)key), false, observer);
    }

    public void registerGlobalContentObserver(String key, ContentObserver observer) {
        mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor((String)key), false, observer);
    }

    @RequiresApi(api=23)
    public boolean systemCanWrite() {
        return Settings.System.canWrite((Context)mContext);
    }

    @RequiresApi(api=23)
    public boolean systemCanDrawOverlays() {
        return Settings.canDrawOverlays((Context)mContext);
    }

    public boolean isOverSeaProduct() {
        System.out.println("SettingDataHelper ROBOT_SETTING_PRODUCT_TYPE " + this.getRobotString(ROBOT_SETTING_PRODUCT_TYPE));
        System.out.println("SettingDataHelper ROBOT_SETTING_ENABLE_ASR_SWITCH " + this.getRobotInt(ROBOT_SETTING_ENABLE_ASR_SWITCH));
        return TextUtils.equals((CharSequence)this.getRobotString(ROBOT_SETTING_PRODUCT_TYPE), (CharSequence)"saiph_oversea");
    }

    public String getRobotPortalOpkID() {
        System.out.println("SettingDataHelper ROBOT_SETTING_PORTAL_OPK " + this.getRobotString(ROBOT_SETTING_PORTAL_OPK));
        return this.getRobotString(ROBOT_SETTING_PORTAL_OPK);
    }

    public String getCloudServerZone() {
        return this.getRobotString(ROBOT_SETTINGS_CLOUD_SERVER_ZONE);
    }

    public int getStandByOpkMode() {
        Log.d((String)TAG, (String)("SettingDataHelper ROBOT_SETTING_STANDBY_OPK_MODE_SWITCH " + this.getRobotInt(ROBOT_SETTING_STANDBY_OPK_MODE_SWITCH)));
        return this.getRobotInt(ROBOT_SETTING_STANDBY_OPK_MODE_SWITCH);
    }

    public int getRadarEnableInStandBy() {
        Log.d((String)TAG, (String)("SettingDataHelper ROBOT_SETTING_RADAR_ENABLE_IN_STADNBY_SWITCH " + this.getRobotInt(ROBOT_SETTING_RADAR_ENABLE_IN_STADNBY_SWITCH)));
        return this.getRobotInt(ROBOT_SETTING_RADAR_ENABLE_IN_STADNBY_SWITCH);
    }

    public boolean isStandByInOpkMode() {
        return this.getStandByOpkMode() == 1;
    }

    public void setCurrentApp(String appName) {
        this.putRobotString("robot_settings_current_app", appName);
    }

    public boolean isRadarEnableInStandby() {
        return this.getRadarEnableInStandBy() == 1;
    }

    private void insert(String pkgName, String pkgSign, String appId) {
        ContentValues values = new ContentValues();
        values.put(PKG_NAME, pkgName);
        values.put(PKG_SIGN, pkgSign);
        values.put(APP_ID, appId);
        values.put(IS_AUTH, Integer.valueOf(0));
        mContext.getContentResolver().insert(Uri.parse((String)AUTH_URI), values);
    }

    private void update(String pkgName, String pkgSign, String appId) {
        ContentValues values = new ContentValues();
        values.put(PKG_SIGN, pkgSign);
        values.put(APP_ID, appId);
        values.put(IS_AUTH, Integer.valueOf(0));
        int updateRows = mContext.getContentResolver().update(Uri.parse((String)AUTH_URI), values, "pkgName=?", new String[]{pkgName});
        Log.i((String)TAG, (String)("update: updateRows=" + updateRows));
    }

    public void setAuthInfo(String pkgName, String pkgSign, String appId) {
        int result = SettingDataHelper.getInstance().compareData(pkgName, pkgSign, appId);
        if (mContext == null) {
            Log.e((String)TAG, (String)"mContext err");
            return;
        }
        Log.e((String)TAG, (String)("setAuthInfo result:" + result));
        if (result > 0) {
            this.update(pkgName, pkgSign, appId);
        } else if (result == 0) {
            this.insert(pkgName, pkgSign, appId);
        } else {
            Log.e((String)TAG, (String)"auth info db err");
        }
    }

    private int compareData(String pkgName, String pkgSign, String appId) {
        Cursor cursor = mContext.getContentResolver().query(Uri.parse((String)AUTH_URI), new String[]{PKG_SIGN, APP_ID}, "pkgName=?", new String[]{String.valueOf(pkgName)}, null);
        if (cursor == null) {
            return -1;
        }
        int result = 0;
        while (cursor.moveToNext()) {
            String sign = cursor.getString(cursor.getColumnIndex(PKG_SIGN));
            String id = cursor.getString(cursor.getColumnIndex(APP_ID));
            if (pkgSign.equals(sign) && appId.equals(id)) continue;
            result = 1;
        }
        cursor.close();
        return result;
    }

    public static enum CloudServerZone {
        DEFAULT("default"),
        US("us");

        String value;

        private CloudServerZone(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

