/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.utils;

import android.os.Environment;
import android.util.Log;
import com.ainirobot.coreservice.client.ProductInfo;
import com.ainirobot.coreservice.utils.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.json.JSONException;
import org.json.JSONObject;

public class FileUtils {
    private static final String TAG = "FileUtils:Core";
    private static final Properties sProperties = ProductInfo.getDeviceProperties();

    public static boolean isEnableVisionRecordForTest() {
        String path = Environment.getExternalStorageDirectory() + File.separator + "enableRecord.json";
        File file = new File(path);
        if (file.isFile() && file.exists()) {
            boolean enable = false;
            String string = FileUtils.loadConfig(file);
            Log.d((String)TAG, (String)("isEnableVisionRecordForTest string=" + string));
            try {
                JSONObject jsonObject = new JSONObject(string);
                enable = jsonObject.optBoolean("enable", false);
                Log.d((String)TAG, (String)("isEnableVisionRecordForTest enable=" + enable));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return enable;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadConfig(File file) {
        FileInputStream is;
        block5: {
            is = null;
            is = new FileInputStream(file);
            int total = ((InputStream)is).available();
            byte[] bytes = new byte[total];
            int len = ((InputStream)is).read(bytes);
            if (total != len) break block5;
            String string = new String(bytes);
            IOUtils.close(is);
            return string;
        }
        try {
            Log.e((String)TAG, (String)"config read err");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.close(is);
                throw throwable;
            }
            IOUtils.close(is);
        }
        IOUtils.close(is);
        return "";
    }

    public static boolean isFileExists(String path, String name) {
        File file = new File(path, name);
        return file.isFile() && file.exists();
    }

    public static boolean isFileExists(String fullPath) {
        File file = new File(fullPath);
        return file.isFile() && file.exists();
    }

    public static boolean isFolderExists(String strFolder) {
        File file = new File(strFolder);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static String getVisionSnapshotCachePath(String cacheId) {
        String path = Environment.getExternalStorageDirectory() + File.separator + "/ninjia/log/vision/snapshot/" + cacheId + File.separator;
        return path;
    }

    public static boolean hasTopIR() {
        return sProperties != null && "1".equals(sProperties.getProperty("TOPIR_mini2", "0"));
    }

    public static boolean hasEsp32() {
        return sProperties != null && "1".equals(sProperties.getProperty("esp32", "0"));
    }

    public static boolean hasChargeIR() {
        return sProperties != null && "1".equals(sProperties.getProperty("CHGIR", "0"));
    }

    public static boolean hasRgbdFm1() {
        return sProperties != null && "1".equals(sProperties.getProperty("RGBD_FM1", "0"));
    }
}

