/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.utils;

import android.os.CountDownTimer;
import android.os.HandlerThread;
import android.util.Log;

public class DelayTimer
extends HandlerThread {
    private final String TAG = "DelayTimer";
    private CountDownTimer mTimer;
    private final long mDelayTime;
    private Runnable mTask;

    public DelayTimer(long delayTime, Runnable task) {
        super("DelayTimer");
        this.mDelayTime = delayTime;
        this.mTask = task;
    }

    public DelayTimer(long delayTime) {
        this(delayTime, null);
    }

    public void setTask(Runnable task) {
        this.mTask = task;
    }

    protected final void onLooperPrepared() {
        this.mTimer = new CountDownTimer(this.mDelayTime, this.mDelayTime){

            public void onTick(long millisUntilFinished) {
            }

            public void onFinish() {
                if (DelayTimer.this.mTask != null) {
                    DelayTimer.this.mTask.run();
                }
            }
        };
        this.mTimer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.mTimer == null) {
            return;
        }
        CountDownTimer countDownTimer = this.mTimer;
        synchronized (countDownTimer) {
            Log.d((String)"DelayTimer", (String)"reset");
            this.mTimer.cancel();
            this.mTimer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.mTimer == null) {
            return;
        }
        CountDownTimer countDownTimer = this.mTimer;
        synchronized (countDownTimer) {
            Log.d((String)"DelayTimer", (String)"cancel");
            this.mTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.mTimer == null) {
            return;
        }
        CountDownTimer countDownTimer = this.mTimer;
        synchronized (countDownTimer) {
            Log.d((String)"DelayTimer", (String)"destroy");
            this.cancel();
            this.quit();
        }
    }
}

