/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.utils;

import com.ainirobot.coreservice.client.Invoker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DelayTask {
    private static DelayTask mInstance = new DelayTask();
    private ScheduledExecutorService mExecutor = Executors.newScheduledThreadPool(5);
    private HashMap<Object, List<Future>> mTasks = new HashMap();

    private DelayTask() {
    }

    private Future submit(Object tag, Runnable runnable, long delay, TimeUnit unit) {
        ScheduledFuture<?> future = this.mExecutor.schedule(runnable, delay, unit);
        this.addTask(tag, future);
        return future;
    }

    private Future submit(Object tag, Runnable runnable, long delay, long period, TimeUnit unit) {
        ScheduledFuture<?> future = this.mExecutor.scheduleAtFixedRate(runnable, delay, period, unit);
        this.addTask(tag, future);
        return future;
    }

    private void addTask(Object tag, Future future) {
        if (tag == null) {
            return;
        }
        if (this.mTasks.containsKey(tag)) {
            this.mTasks.get(tag).add(future);
        } else {
            ArrayList<Future> futures = new ArrayList<Future>();
            futures.add(future);
            this.mTasks.put(tag, futures);
        }
    }

    public void cancelTask(Object tag) {
        List<Future> futures = this.mTasks.get(tag);
        if (futures == null) {
            return;
        }
        for (Future future : futures) {
            if (future == null || future.isCancelled() || future.isDone()) continue;
            future.cancel(true);
        }
        this.mTasks.remove(tag);
    }

    public void cancelTask(Object tag, Future future) {
        List<Future> futures = this.mTasks.get(tag);
        if (futures == null) {
            return;
        }
        future.cancel(true);
        futures.remove(future);
        if (futures.isEmpty()) {
            this.mTasks.remove(tag);
        }
    }

    public static Future submit(Runnable runnable) {
        return mInstance.submit(null, runnable, 0L, TimeUnit.MILLISECONDS);
    }

    public static Future submit(Object tag, Runnable runnable) {
        DelayRunnable delayRunnable = new DelayRunnable(tag, runnable);
        Future future = mInstance.submit(tag, delayRunnable, 0L, TimeUnit.MILLISECONDS);
        delayRunnable.setFuture(future);
        return future;
    }

    public static Future submit(Runnable runnable, long delay) {
        return mInstance.submit(null, runnable, delay, TimeUnit.MILLISECONDS);
    }

    public static Future submit(Object tag, Runnable runnable, long delay) {
        DelayRunnable delayRunnable = new DelayRunnable(tag, runnable);
        Future future = mInstance.submit(tag, delayRunnable, delay, TimeUnit.MILLISECONDS);
        delayRunnable.setFuture(future);
        return future;
    }

    public static Future submit(Runnable runnable, long delay, long period) {
        return mInstance.submit(null, runnable, delay, period, TimeUnit.MILLISECONDS);
    }

    public static Future submit(Object tag, Runnable runnable, long delay, long period) {
        DelayRunnable delayRunnable = new DelayRunnable(tag, runnable);
        Future future = mInstance.submit(tag, delayRunnable, delay, period, TimeUnit.MILLISECONDS);
        return future;
    }

    public static synchronized void cancel(Object tag) {
        mInstance.cancelTask(tag);
    }

    private static synchronized void cancel(Object tag, Future future) {
        if (future == null) {
            return;
        }
        mInstance.cancelTask(tag, future);
    }

    private static class DelayRunnable
    implements Runnable {
        private final Object tag;
        private final Runnable runnable;
        private Future future;

        private DelayRunnable(Object tag, Runnable runnable) {
            this.tag = tag;
            this.runnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.runnable == null) {
                return;
            }
            if (this.tag instanceof Invoker) {
                Invoker invoker = (Invoker)this.tag;
                Object object = this.tag;
                synchronized (object) {
                    if (invoker.isAlive()) {
                        this.runnable.run();
                    }
                }
            } else {
                this.runnable.run();
            }
            DelayTask.cancel(this.tag, this.future);
        }

        void setFuture(Future future) {
            this.future = future;
        }
    }
}

