/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.data.provider;

import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.ainirobot.coreservice.data.provider.SQLiteTable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseProvider
extends ContentProvider {
    private static final String TAG = BaseProvider.class.getSimpleName();
    private final UriMatcher sUriMatcher = new UriMatcher(-1);
    private final Map<Integer, SQLiteTable> sTables = new ConcurrentHashMap<Integer, SQLiteTable>();
    static final Object DBLock = new Object();
    protected SQLiteOpenHelper mDBHelper;

    public BaseProvider() {
        List<SQLiteTable> tables = this.getTables();
        if (tables != null) {
            for (int index = 0; index < tables.size(); ++index) {
                SQLiteTable table = tables.get(index);
                this.sUriMatcher.addURI(table.getAuthority(), table.getTableName(), index);
                this.sTables.put(index, table);
            }
        }
    }

    public boolean onCreate() {
        this.mDBHelper = this.getDBHelper();
        return false;
    }

    public abstract List<SQLiteTable> getTables();

    public abstract SQLiteOpenHelper getDBHelper();

    public String getType(@NonNull Uri uri) {
        int code = this.sUriMatcher.match(uri);
        SQLiteTable table = this.sTables.get(code);
        if (table != null) {
            return table.getContentType();
        }
        return null;
    }

    protected String matchTable(Uri uri) {
        int code = this.sUriMatcher.match(uri);
        SQLiteTable table = this.sTables.get(code);
        if (table != null) {
            return table.getTableName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor query(@NonNull Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        Object object = DBLock;
        synchronized (object) {
            SQLiteQueryBuilder queryBuilder = new SQLiteQueryBuilder();
            String table = this.matchTable(uri);
            queryBuilder.setTables(table);
            SQLiteDatabase db = this.mDBHelper.getReadableDatabase();
            Cursor cursor = queryBuilder.query(db, projection, selection, selectionArgs, null, null, sortOrder);
            if (this.getContext() == null) {
                return null;
            }
            cursor.setNotificationUri(this.getContext().getContentResolver(), uri);
            return cursor;
        }
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        return this.insert(uri, values, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Uri insert(@NonNull Uri uri, ContentValues values, boolean isNotifyChange) throws SQLException {
        Object object = DBLock;
        synchronized (object) {
            String table = this.matchTable(uri);
            SQLiteDatabase db = this.mDBHelper.getWritableDatabase();
            long rowId = 0L;
            db.beginTransaction();
            try {
                rowId = db.insertWithOnConflict(table, null, values, 5);
                db.setTransactionSuccessful();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
            finally {
                db.endTransaction();
            }
            if (rowId > 0L) {
                Uri returnUri = ContentUris.withAppendedId((Uri)uri, (long)rowId);
                if (this.getContext() == null) {
                    return null;
                }
                if (isNotifyChange) {
                    this.getContext().getContentResolver().notifyChange(uri, null);
                }
                return returnUri;
            }
            throw new SQLException("Failed to insert row into " + uri);
        }
    }

    public int bulkInsert(@NonNull Uri uri, @NonNull ContentValues[] values) {
        return this.bulkInsert(uri, values, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int bulkInsert(@NonNull Uri uri, @NonNull ContentValues[] values, boolean isNotifyChange) {
        Object object = DBLock;
        synchronized (object) {
            String table = this.matchTable(uri);
            SQLiteDatabase db = this.mDBHelper.getWritableDatabase();
            db.beginTransaction();
            try {
                for (ContentValues contentValues : values) {
                    db.insertWithOnConflict(table, "_id", contentValues, 4);
                }
                db.setTransactionSuccessful();
                if (this.getContext() == null) {
                    int n = -1;
                    return n;
                }
                if (isNotifyChange) {
                    this.getContext().getContentResolver().notifyChange(uri, null);
                }
                int n = values.length;
                return n;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getMessage());
                throw new SQLException("Failed to insert row into " + uri);
            }
            finally {
                db.endTransaction();
            }
        }
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        return this.delete(uri, selection, selectionArgs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(@NonNull Uri uri, String selection, String[] selectionArgs, boolean isNotifyChange) {
        Object object = DBLock;
        synchronized (object) {
            SQLiteDatabase db = this.mDBHelper.getWritableDatabase();
            int count = 0;
            String table = this.matchTable(uri);
            db.beginTransaction();
            try {
                count = db.delete(table, selection, selectionArgs);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            if (this.getContext() == null) {
                return -1;
            }
            if (isNotifyChange) {
                this.getContext().getContentResolver().notifyChange(uri, null);
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(@NonNull Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        Object object = DBLock;
        synchronized (object) {
            int count;
            SQLiteDatabase db = this.mDBHelper.getWritableDatabase();
            String table = this.matchTable(uri);
            db.beginTransaction();
            try {
                count = db.update(table, values, selection, selectionArgs);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            if (this.getContext() == null) {
                return -1;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(@NonNull Uri uri, ContentValues values, String selection, String[] selectionArgs, boolean isNotifyChange) {
        Object object = DBLock;
        synchronized (object) {
            int count;
            SQLiteDatabase db = this.mDBHelper.getWritableDatabase();
            String table = this.matchTable(uri);
            db.beginTransaction();
            try {
                count = db.update(table, values, selection, selectionArgs);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            if (this.getContext() == null) {
                return -1;
            }
            if (isNotifyChange) {
                this.getContext().getContentResolver().notifyChange(uri, null);
            }
            return count;
        }
    }
}

