/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.data.provider;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.v4.content.CursorLoader;
import android.text.TextUtils;

public abstract class BaseDataHelper {
    private Context mContext;

    public BaseDataHelper(Context context) {
        this.mContext = context;
    }

    public Context getContext() {
        return this.mContext;
    }

    public abstract Uri getContentUri();

    public void notifyChange() {
        this.mContext.getContentResolver().notifyChange(this.getContentUri(), null);
    }

    public void notifyChange(String event) {
        if (TextUtils.isEmpty((CharSequence)event)) {
            this.notifyChange();
            return;
        }
        this.mContext.getContentResolver().notifyChange(Uri.withAppendedPath((Uri)this.getContentUri(), (String)event), null);
    }

    protected final Cursor query(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return this.mContext.getContentResolver().query(this.getContentUri(), projection, selection, selectionArgs, sortOrder);
    }

    public final Cursor query(String selection, String[] selectionArgs) {
        return this.query(null, selection, selectionArgs, null);
    }

    public final Uri insert(ContentValues values) {
        return this.mContext.getContentResolver().insert(this.getContentUri(), values);
    }

    public final int bulkInsert(ContentValues[] values) {
        try {
            return this.mContext.getContentResolver().bulkInsert(this.getContentUri(), values);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public final int update(ContentValues values, String where, String[] whereArgs) {
        return this.mContext.getContentResolver().update(this.getContentUri(), values, where, whereArgs);
    }

    public final int delete(String selection, String[] selectionArgs) {
        return this.mContext.getContentResolver().delete(this.getContentUri(), selection, selectionArgs);
    }

    protected final Cursor getList(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return this.mContext.getContentResolver().query(this.getContentUri(), projection, selection, selectionArgs, sortOrder);
    }

    public CursorLoader getCursorLoader() {
        return this.getCursorLoader(null, null, null, null);
    }

    public final CursorLoader getCursorLoader(String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return new CursorLoader(this.getContext(), this.getContentUri(), projection, selection, selectionArgs, sortOrder);
    }
}

