/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.config;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;

public class ServiceConfig
implements Parcelable {
    private String serviceName;
    @SerializedName(value="\u662f\u5426\u542f\u7528")
    private boolean enable;
    private String service;
    @SerializedName(value="\u914d\u7f6e\u9879")
    private JsonObject config;
    @SerializedName(value="\u81ea\u68c0\u9879")
    private JsonObject inspection;
    private JsonObject publicConfig;
    public static final Parcelable.Creator<ServiceConfig> CREATOR = new Parcelable.Creator<ServiceConfig>(){

        public ServiceConfig createFromParcel(Parcel in) {
            return new ServiceConfig(in);
        }

        public ServiceConfig[] newArray(int size) {
            return new ServiceConfig[size];
        }
    };

    private ServiceConfig(Parcel in) {
        String pubConfig;
        String inspec;
        Gson gson = new Gson();
        this.serviceName = in.readString();
        this.enable = in.readByte() != 0;
        this.service = in.readString();
        String conf = in.readString();
        if (!TextUtils.isEmpty((CharSequence)conf)) {
            this.config = (JsonObject)gson.fromJson(conf, JsonObject.class);
        }
        if (!TextUtils.isEmpty((CharSequence)(inspec = in.readString()))) {
            this.inspection = (JsonObject)gson.fromJson(inspec, JsonObject.class);
        }
        if (!TextUtils.isEmpty((CharSequence)(pubConfig = in.readString()))) {
            this.publicConfig = (JsonObject)gson.fromJson(pubConfig, JsonObject.class);
        }
    }

    public JsonObject getPublicConfig() {
        return this.publicConfig;
    }

    public void setPublicConfig(JsonObject publicConfig) {
        this.publicConfig = publicConfig;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public boolean isInspection() {
        return this.inspection != null && !this.inspection.keySet().isEmpty();
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public void setConfig(JsonObject config) {
        this.config = config;
    }

    public JsonObject getInspection() {
        return this.inspection;
    }

    public void setInspection(JsonObject inspection) {
        this.inspection = inspection;
    }

    public int describeContents() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceConfig)) {
            return false;
        }
        ServiceConfig config = (ServiceConfig)obj;
        return TextUtils.equals((CharSequence)this.serviceName, (CharSequence)config.getServiceName());
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.serviceName == null ? -1 : this.serviceName.hashCode());
        return hashCode;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.serviceName);
        dest.writeByte((byte)(this.enable ? 1 : 0));
        dest.writeString(this.service);
        dest.writeString(this.config == null ? "" : this.config.toString());
        dest.writeString(this.inspection == null ? "" : this.inspection.toString());
        dest.writeString(this.publicConfig == null ? "" : this.publicConfig.toString());
    }

    public String toString() {
        return "ServiceConfig{serviceName='" + this.serviceName + '\'' + ", enable=" + this.enable + ", service='" + this.service + '\'' + ", config=" + this.config + ", inspection=" + this.inspection + '}';
    }
}

