/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.upload.bi;

import com.ainirobot.coreservice.client.upload.bi.BaseBiReport;

public class CallChainReport
extends BaseBiReport {
    private static final String TABLE_NAME = "mini_robot_gb_call_chain";
    private static final String BUSINESS_NAME = "business_name";
    private static final String SOURCE = "source";
    private static final String PACKAGE_NAME = "package_name";
    private static final String NODE_CLASS_NAME = "node_class_name";
    private static final String NODE_METHOD_TYPE = "node_method_type";
    private static final String NODE_METHOD_NAME = "node_method_name";
    private static final String NODE_METHOD_NOTE = "node_method_note";
    private static final String NODE_PARAMS_NOTE = "node_params_note";
    private static final String NODE_PARAMS = "node_params";
    private static final String NODE_RESULT = "node_result";
    private static final String NODE_NOTE = "node_note";
    private static final String NODE_ENTRANCE = "node_entrance";
    private static final String NODE_MIDDLE = "node_middle";
    private static final String NODE_EXPORT = "node_export";
    private static final String STATUS = "status";
    private static final String RESULT = "result";
    private static final String WAKEUP_ID = "wakeup_id";
    private static final String CTIME = "ctime";

    public CallChainReport(String businessName) {
        this(TABLE_NAME, businessName);
    }

    public CallChainReport(String tableName, String businessName) {
        super(tableName);
        this.initData();
        this.addBusinessName(businessName);
    }

    protected void initData() {
        this.addBusinessName("");
        this.addSource("");
        this.addPackageName("");
        this.addNodeMethodType("");
        this.addNodeMethodName("");
        this.addNodeMethodAnnotation("");
        this.addNodeParamsAnnotation("");
        this.addNodeParams("");
        this.addNodeResult("");
        this.addNodeEntrance("");
        this.addNodeMiddle("");
        this.addNodeExport("");
        this.addStatus("");
        this.addResult("");
        this.addWakeupId("");
    }

    public CallChainReport addBusinessName(String system) {
        this.addData(BUSINESS_NAME, system);
        return this;
    }

    public CallChainReport addSource(String source) {
        this.addData(SOURCE, source);
        return this;
    }

    public CallChainReport addPackageName(String packageName) {
        this.addData(PACKAGE_NAME, packageName);
        return this;
    }

    public CallChainReport addClassName(String packageName) {
        this.addData(NODE_CLASS_NAME, packageName);
        return this;
    }

    public CallChainReport addNodeMethodType(String nodeMethodType) {
        this.addData(NODE_METHOD_TYPE, nodeMethodType);
        return this;
    }

    public CallChainReport addNodeMethodName(String nodeMethodName) {
        this.addData(NODE_METHOD_NAME, nodeMethodName);
        return this;
    }

    public CallChainReport addNodeMethodAnnotation(String nodeMethodAnnotation) {
        this.addData(NODE_METHOD_NOTE, nodeMethodAnnotation);
        return this;
    }

    public CallChainReport addNodeParamsAnnotation(String nodeParamsAnnotation) {
        this.addData(NODE_PARAMS_NOTE, nodeParamsAnnotation);
        return this;
    }

    public CallChainReport addNodeParams(String nodeParams) {
        this.addData(NODE_PARAMS, nodeParams);
        return this;
    }

    public CallChainReport addNodeResult(String nodeResult) {
        this.addData(NODE_RESULT, nodeResult);
        return this;
    }

    public CallChainReport addNodeNote(String nodeNote) {
        this.addData(NODE_NOTE, nodeNote);
        return this;
    }

    public CallChainReport addNodeEntrance(String nodeEntrance) {
        this.addData(NODE_ENTRANCE, nodeEntrance);
        return this;
    }

    public CallChainReport addNodeMiddle(String nodeMiddle) {
        this.addData(NODE_MIDDLE, nodeMiddle);
        return this;
    }

    public CallChainReport addNodeExport(String nodeExport) {
        this.addData(NODE_EXPORT, nodeExport);
        return this;
    }

    public CallChainReport addStatus(String status) {
        this.addData(STATUS, status);
        return this;
    }

    public CallChainReport addResult(String result) {
        this.addData(RESULT, result);
        return this;
    }

    public CallChainReport addWakeupId(String wakeupId) {
        this.addData(WAKEUP_ID, wakeupId);
        return this;
    }

    public CallChainReport addSourceRom() {
        this.addSource("rom");
        return this;
    }

    public CallChainReport addSourceRobotOs() {
        this.addSource("robot_os");
        return this;
    }

    public CallChainReport addSourceVisionSdk() {
        this.addSource("vision_sdk");
        return this;
    }

    public CallChainReport addSourceRoverService() {
        this.addSource("rover_service");
        return this;
    }

    public CallChainReport addPackageNamePlatform() {
        this.addPackageName("com.ainirobot.platform");
        return this;
    }

    public CallChainReport addPackageNameCoreService() {
        this.addPackageName("com.ainirobot.coreservice");
        return this;
    }

    public CallChainReport addPackageNameNavigationService() {
        this.addPackageName("com.ainirobot.navigationservice");
        return this;
    }

    public CallChainReport addPackageNameHeadService() {
        this.addPackageName("com.ainirobot.headservice");
        return this;
    }

    public CallChainReport addNodeMethodTypeApiCall() {
        this.addNodeMethodType("api_call");
        return this;
    }

    public CallChainReport addNodeMethodTypeApiCallback() {
        this.addNodeMethodType("api_callback");
        return this;
    }

    public CallChainReport addNodeMethodTypeEvent() {
        this.addNodeMethodType("event");
        return this;
    }

    public CallChainReport addNodeMethodTypeLifecycle() {
        this.addNodeMethodType("lifecycle");
        return this;
    }

    public CallChainReport addNodeMethodTypeFunction() {
        this.addNodeMethodType("function");
        return this;
    }

    @Override
    public void report() {
        this.reportV();
    }

    public void reportV() {
        this.addData(CTIME, System.currentTimeMillis());
    }

    public void reportD() {
        this.addData(CTIME, System.currentTimeMillis());
        super.reportCallChainD();
    }
}

