/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.upload.bi;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONException;
import org.json.JSONObject;

public class BiSocketClient {
    private static final String TAG = "BiSocketClient";
    private static final int CORE_THREAD_POOL_SIZE = 3;
    private static final int MAX_THREAD_POOL_SIZE = 10;
    private static final int MAX_BUF_SIZE = 20;
    private static final int PORT = 9191;
    private static final int DELAY_SECONEDS = 10;
    private static final int MAX_RETRY = 3;
    private ExecutorService executorService;
    private ScheduledExecutorService timerExecutor;
    private ScheduledFuture timerFuture;
    private AtomicInteger retryCount;
    private Socket socket;
    private OutputStream outputStream;
    private BufferedWriter bufferedWriter;
    private LimitQueue<String> bufferMsg;
    private boolean isConnecting = false;

    public BiSocketClient() {
        final AtomicInteger threadNum = new AtomicInteger(0);
        this.executorService = new ThreadPoolExecutor(3, 10, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(@NonNull Runnable r) {
                return new Thread(r, "BiSocketClient Thread-" + threadNum.incrementAndGet());
            }
        });
        this.timerExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(@NonNull Runnable r) {
                return new Thread(r, "BiSocketClient Timer");
            }
        });
        this.retryCount = new AtomicInteger(0);
        this.bufferMsg = new LimitQueue(20);
    }

    public void connectServer() {
        Log.i((String)TAG, (String)"connectServer");
        this.executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BiSocketClient biSocketClient = BiSocketClient.this;
                synchronized (biSocketClient) {
                    if (BiSocketClient.this.isConnecting) {
                        BiSocketClient.this.resetRetryConnect();
                        return;
                    }
                    try {
                        InetAddress serverAddr = InetAddress.getByName(null);
                        BiSocketClient.this.socket = new Socket(serverAddr, 9191);
                        if (BiSocketClient.this.socket.isConnected()) {
                            Log.i((String)BiSocketClient.TAG, (String)"socket connectServer success!");
                            BiSocketClient.this.isConnecting = true;
                            BiSocketClient.this.outputStream = BiSocketClient.this.socket.getOutputStream();
                            BiSocketClient.this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(BiSocketClient.this.outputStream));
                            BiSocketClient.this.resetRetryConnect();
                            BiSocketClient.this.checkConnectStatus(BiSocketClient.this.socket);
                            BiSocketClient.this.sendBufferMsg();
                        }
                    }
                    catch (IOException e) {
                        Log.i((String)BiSocketClient.TAG, (String)("socket connectServer failed:" + e.toString()));
                        BiSocketClient.this.retryConnectServer();
                    }
                }
            }
        });
    }

    public void biReport(String tableName, String data) {
        this.biReport("bi_type_normal", 0, tableName, data);
    }

    public void biReport(String type, int level, String tableName, String data) {
        if (!TextUtils.isEmpty((CharSequence)tableName) && !TextUtils.isEmpty((CharSequence)data)) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("tableName", (Object)tableName);
                jsonObject.put("data", (Object)data);
                jsonObject.put("type", (Object)type);
                jsonObject.put("level", level);
                jsonObject.put("notForce", false);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            String msg = jsonObject.toString();
            this.sendSocketMsg(msg);
        }
    }

    public void biReport(String type, int level, String tableName, String data, boolean notForce) {
        if (!TextUtils.isEmpty((CharSequence)tableName) && !TextUtils.isEmpty((CharSequence)data)) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("tableName", (Object)tableName);
                jsonObject.put("data", (Object)data);
                jsonObject.put("type", (Object)type);
                jsonObject.put("level", level);
                jsonObject.put("notForce", notForce);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            String msg = jsonObject.toString();
            this.sendSocketMsg(msg);
        }
    }

    private void retryConnectServer() {
        if (this.retryCount.get() >= 3) {
            this.resetRetryConnect();
            Log.i((String)TAG, (String)"stop retry connectServer");
            return;
        }
        this.timerFuture = this.timerExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                BiSocketClient.this.retryCount.incrementAndGet();
                Log.i((String)BiSocketClient.TAG, (String)("retry connectServer-" + BiSocketClient.this.retryCount.get()));
                BiSocketClient.this.connectServer();
            }
        }, 10L, TimeUnit.SECONDS);
    }

    private void resetRetryConnect() {
        if (this.timerFuture != null) {
            this.timerFuture.cancel(true);
        }
        this.retryCount.set(0);
    }

    private void sendSocketMsg(final String msg) {
        this.executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BiSocketClient biSocketClient = BiSocketClient.this;
                synchronized (biSocketClient) {
                    if (BiSocketClient.this.isConnecting && BiSocketClient.this.bufferedWriter != null) {
                        try {
                            BiSocketClient.this.bufferedWriter.write(msg);
                            BiSocketClient.this.bufferedWriter.newLine();
                            BiSocketClient.this.bufferedWriter.flush();
                            Log.v((String)BiSocketClient.TAG, (String)("send bi socket msg\uff1a" + msg));
                        }
                        catch (IOException e) {
                            Log.e((String)BiSocketClient.TAG, (String)("sendSocketMsg failed:" + e.toString()));
                            BiSocketClient.this.handleSocketBroken(msg);
                        }
                    } else {
                        BiSocketClient.this.handleSocketBroken(msg);
                    }
                }
            }
        });
    }

    private void checkConnectStatus(final Socket socket) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (socket.getInputStream().read() == -1) {
                        Log.i((String)BiSocketClient.TAG, (String)"the socket connection is interrupted!");
                        BiSocketClient.this.isConnecting = false;
                        BiSocketClient.this.resetRetryConnect();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void handleSocketBroken(String msg) {
        Log.i((String)TAG, (String)"handleSocketBroken");
        this.isConnecting = false;
        this.bufferMsg.offer(msg);
        this.closeResource(this.bufferedWriter);
        this.closeResource(this.outputStream);
        this.closeResource(this.socket);
        this.connectServer();
    }

    private void sendBufferMsg() {
        for (String msg : this.bufferMsg) {
            this.sendSocketMsg(msg);
        }
        this.bufferMsg.clear();
    }

    private void closeResource(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                closeable = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class LimitQueue<E>
    extends LinkedList<E> {
        private int limit;

        public LimitQueue(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean offer(E e) {
            if (this.size() >= this.limit) {
                this.poll();
            }
            return super.offer(e);
        }
    }
}

