/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.upload.bi;

import android.util.Log;
import com.ainirobot.coreservice.client.upload.bi.BiReport;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BaseBiReport {
    protected static final String TAG = "BIReport";
    private static final String DEFAULT_VALUE = "";
    private String tableName;
    private ConcurrentHashMap<String, String> reportDatas = new ConcurrentHashMap(8);

    public BaseBiReport(String tableName) {
        this.tableName = tableName;
    }

    private BaseBiReport() {
    }

    public void addData(String key, Object value) {
        this.reportDatas.put(key, value == null ? DEFAULT_VALUE : String.valueOf(value));
    }

    public void clearReportDatas() {
        this.reportDatas.clear();
    }

    public void report() {
        this.reportNormalV();
    }

    protected void reportNormalV() {
        this.startBiReport("bi_type_normal", 0);
    }

    protected void reportCallChainV() {
        this.startBiReport("bi_type_call_chain", 0, true);
    }

    protected void reportCallChainD() {
        this.startBiReport("bi_type_call_chain", 1, true);
    }

    private void startBiReport(String type, int level) {
        if (this.reportDatas.size() > 0) {
            Log.i((String)TAG, (String)("start bi report: type=" + type + " level=" + level + " " + this.tableName + "-" + this.reportDatas.toString()));
            BiReport.report(type, level, this.tableName, this.mapToStr(this.reportDatas));
        }
    }

    private void startBiReport(String type, int level, boolean notForce) {
        if (this.reportDatas.size() > 0) {
            Log.i((String)TAG, (String)("start bi report: type=" + type + " level=" + level + " notForce=" + notForce + " " + this.tableName + "-" + this.reportDatas.toString()));
            BiReport.report(type, level, this.tableName, this.mapToStr(this.reportDatas));
        }
    }

    private String mapToStr(Map<String, String> dataMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

