/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.techreport;

import android.content.Context;
import com.ainirobot.coreservice.client.ProductInfo;
import com.ainirobot.coreservice.client.upload.bi.BaseBiReport;

public class CallChainReport
extends BaseBiReport {
    private static final String CALL_ID = "call_id";
    private static final String BUSINESS_NAME = "business_name";
    private static final String DATA_SOURCE = "data_source";
    private static final String PACKAGE_NAME = "package_name";
    private static final String NODE_CLASS_NAME = "node_class_name";
    private static final String NODE_METHOD_TYPE = "node_method_type";
    private static final String NODE_METHOD_NAME = "node_method_name";
    private static final String NODE_PARAMS = "node_params";
    private static final String NODE_NOTE = "node_note";
    private static final String NODE_STACK_TRACE = "node_stack_trace";
    private static final String NODE_TYPE = "node_type";
    private static final String WAKEUP_ID = "wakeup_id";
    private static final String CTIME = "ctime";
    private Context mContext;

    public CallChainReport() {
        super("gb_robot_os_call_chain");
    }

    public CallChainReport(Context context, String className) {
        super("gb_robot_os_call_chain");
        this.mContext = context;
        this.addData(NODE_CLASS_NAME, className);
    }

    public CallChainReport(Context cotext, String className, String businessName) {
        super("gb_robot_os_call_chain");
        this.mContext = cotext;
        this.addData(NODE_CLASS_NAME, className);
        this.addData(BUSINESS_NAME, businessName);
    }

    public void setClassName(String className) {
        this.addData(NODE_CLASS_NAME, className);
    }

    public void setBusinessName(String businessName) {
        this.addData(BUSINESS_NAME, businessName);
    }

    @Override
    public void report() {
        if (this.mContext != null) {
            this.addData(PACKAGE_NAME, this.mContext.getPackageName());
        }
        this.addData(CTIME, System.currentTimeMillis());
        if (!ProductInfo.isDeliveryProduct() && !ProductInfo.isMeissaPlus()) {
            super.report();
        }
    }

    public NodeMethod invokeNodeMethod(String methodName, int type) {
        NodeMethod method = new NodeMethod(methodName, type);
        return method;
    }

    public NodeMethod invokeNodeMethod(String methodName) {
        NodeMethod method = new NodeMethod(methodName);
        return method;
    }

    public NodeInfo invokeNodeInfo(String callId, String param, String note, int type, int dataResource, String stackTrace) {
        NodeInfo info = new NodeInfo(callId, param, note, type, dataResource, stackTrace);
        return info;
    }

    public NodeInfo invokeNodeInfo(String param, String note, int type, int dataResource) {
        NodeInfo info = new NodeInfo(param, note, type, dataResource);
        return info;
    }

    public NodeInfo invokeNodeInfo(String param, String note, int type) {
        NodeInfo info = new NodeInfo(param, note, type, 1);
        return info;
    }

    public NodeInfo invokeNodeInfo(String param, String note) {
        NodeInfo info = new NodeInfo(param, note);
        return info;
    }

    public class NodeInfo {
        public static final int TYPE_NORMAL = 1;
        public static final int TYPE_ABNORMAL = 2;
        public static final int TYPE_ERROR = -1;
        public static final int DATA_ROBOT_OS = 1;
        public static final int DATA_ROM = 2;
        public static final int DATA_VISION = 3;
        public static final int DATA_ROVER = 4;
        public static final int DATA_SPEECH = 5;
        public static final int DATA_CAN = 6;
        public static final int DATA_TK1 = 7;
        public static final int DATA_TX1 = 8;

        NodeInfo(String callId, String param, String note, int type, int dataResource, String stackTrace) {
            CallChainReport.this.addData(CallChainReport.CALL_ID, callId);
            CallChainReport.this.addData(CallChainReport.NODE_NOTE, note);
            CallChainReport.this.addData(CallChainReport.NODE_PARAMS, param);
            CallChainReport.this.addData(CallChainReport.NODE_STACK_TRACE, stackTrace);
            CallChainReport.this.addData(CallChainReport.NODE_TYPE, type);
            CallChainReport.this.addData(CallChainReport.DATA_SOURCE, dataResource);
        }

        NodeInfo(String param, String note, int type, int dataResource) {
            CallChainReport.this.addData(CallChainReport.NODE_NOTE, note);
            CallChainReport.this.addData(CallChainReport.NODE_PARAMS, param);
            CallChainReport.this.addData(CallChainReport.NODE_TYPE, type);
            CallChainReport.this.addData(CallChainReport.DATA_SOURCE, dataResource);
        }

        NodeInfo(String param, String note) {
            CallChainReport.this.addData(CallChainReport.NODE_NOTE, note);
            CallChainReport.this.addData(CallChainReport.NODE_PARAMS, param);
            CallChainReport.this.addData(CallChainReport.NODE_TYPE, 1);
            CallChainReport.this.addData(CallChainReport.DATA_SOURCE, 1);
        }

        public NodeInfo(String param) {
            CallChainReport.this.addData(CallChainReport.NODE_PARAMS, param);
            CallChainReport.this.addData(CallChainReport.NODE_TYPE, 1);
            CallChainReport.this.addData(CallChainReport.DATA_SOURCE, 1);
        }

        public void setParam(String param) {
            CallChainReport.this.addData(CallChainReport.NODE_PARAMS, param);
        }

        public void setNote(String note) {
            CallChainReport.this.addData(CallChainReport.NODE_NOTE, note);
        }

        public void setType(int type) {
            CallChainReport.this.addData(CallChainReport.NODE_TYPE, type);
        }

        public void setStackTrace(String stackTrace) {
            CallChainReport.this.addData(CallChainReport.NODE_STACK_TRACE, stackTrace);
        }

        public void setDataResource(int dataResource) {
            CallChainReport.this.addData(CallChainReport.DATA_SOURCE, dataResource);
        }
    }

    public class NodeMethod {
        public static final int TYPE_API_CALL = 1;
        public static final int TYPE_API_CALLBACK = 2;
        public static final int TYPE_EVENT_REPORT = 3;
        public static final int TYPE_LIFE_CYCLE = 4;
        public static final int TYPE_FUNCTION = 5;

        NodeMethod(String methodName, int type) {
            CallChainReport.this.addData(CallChainReport.NODE_METHOD_NAME, methodName);
            CallChainReport.this.addData(CallChainReport.NODE_METHOD_TYPE, type);
        }

        NodeMethod(String methodName) {
            CallChainReport.this.addData(CallChainReport.NODE_METHOD_NAME, methodName);
            CallChainReport.this.addData(CallChainReport.NODE_METHOD_TYPE, 5);
        }

        public void setMethodName(String methodName) {
            CallChainReport.this.addData(CallChainReport.NODE_METHOD_NAME, methodName);
        }

        public void setType(int type) {
            CallChainReport.this.addData(CallChainReport.NODE_METHOD_TYPE, type);
        }
    }
}

