/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.surfaceshare;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import android.view.Surface;
import com.ainirobot.coreservice.IRobotBinderPool;
import com.ainirobot.coreservice.ISurfaceShareApi;
import com.ainirobot.coreservice.client.BaseSubApi;
import com.ainirobot.coreservice.client.messagedispatcher.MessageDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.SurfaceShareDispatcher;
import com.ainirobot.coreservice.client.surfaceshare.SurfaceShareBean;
import com.ainirobot.coreservice.client.surfaceshare.SurfaceShareListener;
import com.google.gson.Gson;

public class SurfaceShareApi
extends BaseSubApi {
    private static final String TAG = SurfaceShareApi.class.getSimpleName();
    private static SurfaceShareApi instance;
    private String mPackageName;
    private ISurfaceShareApi mApi;
    private Gson mGson = new Gson();
    private MessageDispatcher mMessageDispatcher = new MessageDispatcher();

    private SurfaceShareApi() {
    }

    public static SurfaceShareApi getInstance() {
        if (instance == null) {
            instance = new SurfaceShareApi();
        }
        return instance;
    }

    public int requestImageFrame(Surface surface, SurfaceShareBean bean, SurfaceShareListener listener) {
        Log.d((String)TAG, (String)"requestImageFrame");
        if (this.mApi == null || surface == null) {
            return -1;
        }
        try {
            if (bean == null) {
                bean = new SurfaceShareBean();
            }
            bean.setPackageName(this.mPackageName);
            String jsonStr = this.mGson.toJson((Object)bean);
            Bundle bundle = new Bundle();
            bundle.putParcelable("surface", (Parcelable)surface);
            SurfaceShareDispatcher surfaceShareDispatcher = null;
            if (listener != null) {
                surfaceShareDispatcher = this.mMessageDispatcher.obtainSurfaceShareDispatcher(listener);
            }
            return this.mApi.requestImageFrame(bundle, jsonStr, surfaceShareDispatcher);
        }
        catch (RemoteException e) {
            return -3;
        }
    }

    public int abandonImageFrame(SurfaceShareBean bean) {
        Log.d((String)TAG, (String)"abandonImageFrame");
        if (this.mApi == null) {
            return -1;
        }
        try {
            if (bean == null) {
                bean = new SurfaceShareBean();
            }
            bean.setPackageName(this.mPackageName);
            String jsonStr = this.mGson.toJson((Object)bean);
            return this.mApi.abandonImageFrame(jsonStr);
        }
        catch (RemoteException e) {
            return -3;
        }
    }

    public boolean isUsed() {
        Log.d((String)TAG, (String)"isUsed");
        if (this.mApi == null) {
            return false;
        }
        try {
            return this.mApi.isUsed();
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public void onConnect(IRobotBinderPool robotBinderPool, Context context) {
        Log.d((String)TAG, (String)("onConnect packageName: " + context.getPackageName()));
        try {
            this.mApi = ISurfaceShareApi.Stub.asInterface(robotBinderPool.queryBinder(11, context.getPackageName()));
            this.mPackageName = context.getPackageName();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDisconnect() {
        Log.d((String)TAG, (String)"onDisconnect");
    }
}

