/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.speech.entity;

import android.text.TextUtils;
import android.util.Log;

public enum LangParamsEnum {
    UNDEFINED("\u672a\u5b9a\u4e49", "undefined", -1),
    ZH_CN("\u666e\u901a\u8bdd", "zh_CN", 1),
    EN_US("\u7f8e\u56fd\u82f1\u8bed", "en_US", 2),
    KO_KR("\u97e9\u8bed", "ko_KR", 3),
    JA_JP("\u65e5\u8bed", "ja_JP", 4),
    TH_TH("\u6cf0\u8bed", "th_TH", 5),
    ES_ES("\u897f\u73ed\u7259\u8bed", "es_ES", 6),
    DE_DE("\u5fb7\u8bed", "de_DE", 7),
    RU_RU("\u4fc4\u8bed", "ru_RU", 8),
    FR_FR("\u6cd5\u8bed", "fr_FR", 9),
    PT_PT("\u8461\u8404\u7259\u8bed", "pt_PT", 10),
    NL_NL("\u8377\u5170\u8bed", "nl_NL", 11),
    IT_IT("\u610f\u5927\u5229\u8bed", "it_IT", 12),
    AR_EG("\u963f\u62c9\u4f2f\u8bed", "ar_EG", 13),
    DA_DK("\u4e39\u9ea6\u8bed", "da_DK", 14),
    FI_FI("\u82ac\u5170\u8bed", "fi_FI", 15),
    HI_IN("\u5317\u5370\u5ea6\u8bed", "hi_IN", 16),
    NB_NO("\u632a\u5a01\u8bed", "nb_NO", 17),
    PL_PL("\u6ce2\u5170\u8bed", "pl_PL", 18),
    SV_SE("\u745e\u5178\u8bed", "sv_SE", 19),
    CA_ES("\u5609\u6cf0\u7f57\u5c3c\u4e9a\u8bed", "ca_ES", 20),
    EN_AU("\u6fb3\u6d32\u82f1\u8bed", "en_AU", 22),
    EN_CA("\u52a0\u62ff\u5927\u82f1\u8bed", "en_CA", 23),
    EN_GB("\u82f1\u56fd\u82f1\u8bed", "en_GB", 24),
    EN_IN("\u5370\u5ea6\u82f1\u8bed", "en_IN", 25),
    EN_NZ("\u65b0\u897f\u5170\u82f1\u8bed", "en_NZ", 26),
    ZH_GD("\u7ca4\u8bed", "zh_GD", 100),
    ZH_SH("\u4e0a\u6d77\u8bdd", "zh_SH", 101),
    ZH_TW("\u53f0\u6e7e\u8bdd", "zh_TW", 102),
    ZH_CS("\u957f\u6c99\u8bdd", "zh_CS", 103),
    AR_SA("\u6c99\u7279\u963f\u62c9\u4f2f\u8bed", "ar_SA", 104),
    Ro_Ro("\u7f57\u9a6c\u5c3c\u4e9a\u8bed", "ro_RO", 105),
    MS_MY("\u9a6c\u6765\u897f\u4e9a\u8bed", "ms_MY", 106),
    VI_VN("\u8d8a\u5357\u8bed", "vi_VN", 107),
    IN_ID("\u5370\u5ea6\u5c3c\u897f\u4e9a\u8bed", "in_ID", 108),
    FIL_PH("\u83f2\u5f8b\u5bbe\u8bed", "fil_PH", 109),
    TR_TR("\u571f\u8033\u5176\u8bed", "tr_TR", 110),
    CS_CZ("\u6377\u514b\u8bed", "cs_CZ", 111),
    EL_GR("\u5e0c\u814a\u8bed", "el_GR", 112),
    HU_HU("\u5308\u7259\u5229\u8bed", "hu_HU", 113),
    PT_BR("\u8461\u8404\u7259\u8bed\uff08\u5df4\u897f\uff09", "pt_BR", 114),
    SK_SK("\u65af\u6d1b\u4f10\u514b\u8bed", "sk_SK", 115);

    private static String TAG;
    public final String chineseName;
    public final String codeName;
    public final int codeValue;

    private LangParamsEnum(String chineseName, String codeName, int codeValue) {
        this.chineseName = chineseName;
        this.codeName = codeName;
        this.codeValue = codeValue;
    }

    public static LangParamsEnum getLangEnumByChineseName(String chineseName) {
        if (TextUtils.isEmpty((CharSequence)chineseName)) {
            Log.e((String)TAG, (String)("chineseName: " + chineseName));
            return ZH_CN;
        }
        for (LangParamsEnum lang : LangParamsEnum.values()) {
            if (!chineseName.equals(lang.chineseName)) continue;
            return lang;
        }
        return ZH_CN;
    }

    public static LangParamsEnum getLangEnumByCodeValue(int codeValue) {
        for (LangParamsEnum lang : LangParamsEnum.values()) {
            if (codeValue != lang.codeValue) continue;
            return lang;
        }
        Log.e((String)TAG, (String)("codeValue: " + codeValue));
        return ZH_CN;
    }

    public static LangParamsEnum getLangEnumByCodeName(String codeName) {
        if (TextUtils.isEmpty((CharSequence)codeName)) {
            Log.e((String)TAG, (String)("codeName: " + codeName));
            return ZH_CN;
        }
        for (LangParamsEnum lang : LangParamsEnum.values()) {
            if (!codeName.equals(lang.codeName)) continue;
            return lang;
        }
        return ZH_CN;
    }

    static {
        TAG = LangParamsEnum.class.getSimpleName();
    }
}

