/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.speech;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.ainirobot.base.OrionBase;
import com.ainirobot.coreservice.ISkill;
import com.ainirobot.coreservice.client.ApiListener;
import com.ainirobot.coreservice.client.BaseApi;
import com.ainirobot.coreservice.client.IntentUtil;
import com.ainirobot.coreservice.client.ProductInfo;
import com.ainirobot.coreservice.client.listener.TextListener;
import com.ainirobot.coreservice.client.listener.ToneListener;
import com.ainirobot.coreservice.client.messagedispatcher.TextDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.ToneDispatcher;
import com.ainirobot.coreservice.client.robotsetting.RobotSettingApi;
import com.ainirobot.coreservice.client.speech.SkillCallback;
import com.ainirobot.coreservice.client.speech.SkillServerCheckListener;
import com.ainirobot.coreservice.client.speech.entity.ASRParams;
import com.ainirobot.coreservice.client.speech.entity.LangJson;
import com.ainirobot.coreservice.client.speech.entity.TTSEntity;
import com.ainirobot.coreservice.client.speech.entity.TTSParams;
import com.ainirobot.coreservice.config.SceneEntity;
import com.ainirobot.coreservice.listener.IMusicListener;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class SkillApi
extends BaseApi {
    private static final String TAG = SkillApi.class.getSimpleName();
    private ISkill mSkill;
    private Gson mGson = new GsonBuilder().disableHtmlEscaping().create();
    protected ServiceConnection apiConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            SkillApi.this.mSkill = ISkill.Stub.asInterface(service);
            SkillApi.this.mIsServiceConnected = true;
            SkillApi.this.notifyEventApiConnected();
        }

        public void onServiceDisconnected(ComponentName className) {
            SkillApi.this.mIsServiceConnected = false;
            SkillApi.this.notifyEventApiDisconnected();
        }
    };

    public void connectApi(Context context, ApiListener listener) {
        this.ctx = context;
        String zone = RobotSettingApi.getInstance().getRobotString("robot_settings_cloud_server_zone");
        OrionBase.setDomainEnv(ProductInfo.isOverSea(), zone, RobotSettingApi.getInstance().getRobotInt("robot_setting_system_environment") == 1);
        OrionBase.start(this.ctx, null);
        this.addApiEventListener(listener);
        Intent intent = IntentUtil.createExplicitIntent("com.ainirobot.speechasrservice", "com.ainirobot.speechasrservice.SpeechService", context.getPackageName());
        context.bindService(intent, this.apiConnection, 1);
    }

    public void connectApi(Context context) {
        this.ctx = context;
        String zone = RobotSettingApi.getInstance().getRobotString("robot_settings_cloud_server_zone");
        Log.d((String)TAG, (String)("SkillApi connnectApi zone: " + zone));
        OrionBase.setDomainEnv(ProductInfo.isOverSea(), zone, RobotSettingApi.getInstance().getRobotInt("robot_setting_system_environment") == 1);
        OrionBase.start(this.ctx, null);
        Intent intent = IntentUtil.createExplicitIntent("com.ainirobot.speechasrservice", "com.ainirobot.speechasrservice.SpeechService", context.getPackageName());
        context.bindService(intent, this.apiConnection, 1);
    }

    @Override
    public void disconnectApi() {
        try {
            this.removeAllApiEventListeners();
            if (null != this.ctx) {
                this.ctx.unbindService(this.apiConnection);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void registerCallBack(SkillCallback cb) {
        try {
            this.mSkill.registerCallBack(cb);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean unregisterCallBack(SkillCallback cb) {
        try {
            this.mSkill.unregisterCallBack(cb);
            return true;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Deprecated
    public void playText(String text, TextListener listener) {
        try {
            TextDispatcher textDispatcher = null;
            if (listener != null) {
                textDispatcher = this.mMessageDispatcher.obtainTextDispatcher(listener);
            }
            this.mSkill.playText(text, textDispatcher);
            OrionBase.logApi(2, "playText", "");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void playText(TTSEntity ttsEntity, TextListener listener) {
        try {
            TextDispatcher textDispatcher = null;
            if (listener != null) {
                textDispatcher = this.mMessageDispatcher.obtainTextDispatcher(listener);
            }
            if (null != ttsEntity) {
                this.mSkill.playText(this.mGson.toJson((Object)ttsEntity), textDispatcher);
            }
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("ttsEntity", true);
            OrionBase.logApi(2, "playText", SkillApi.getParamJsonObjectString(param));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void downloadTtsAudio(String ttsEntitiesJson) {
        try {
            this.mSkill.downloadTtsAudio(ttsEntitiesJson);
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("downloadTtsAudio", ttsEntitiesJson);
            OrionBase.logApi(2, "downloadTtsAudio", SkillApi.getParamJsonObjectString(param));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public String getSpokemanListByLanguage(String lang) {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("lang", lang);
            OrionBase.logApi(2, "getSpokemanListByLanguage", SkillApi.getParamJsonObjectString(param));
            return this.mSkill.getSpokemanListByLanguage(lang);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setWakeupHintClosed(boolean isWakeupHintClosed) {
        try {
            this.mSkill.setWakeupHintClosed(isWakeupHintClosed);
            OrionBase.logApi(2, "setWakeupHintClosed", "");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setTTSSpeechSpeed(int value) {
        try {
            this.mSkill.setTTSParams("SpeechSpeed", value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setTTSParams(@TTSParams String ttsType, int value) {
        try {
            this.mSkill.setTTSParams(ttsType, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void playTone(String type, ToneListener listener) {
        try {
            ToneDispatcher toneDispatcher = null;
            if (listener != null) {
                toneDispatcher = this.mMessageDispatcher.obtainToneDispatcher(listener);
            }
            this.mSkill.playTone(type, toneDispatcher);
            OrionBase.logApi(2, "playTone", "");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void playToneByLocalPath(String localPath, ToneListener listener) {
        try {
            ToneDispatcher toneDispatcher = null;
            if (listener != null) {
                toneDispatcher = this.mMessageDispatcher.obtainToneDispatcher(listener);
            }
            this.mSkill.playToneByLocalPath(localPath, toneDispatcher);
            OrionBase.logApi(2, "playToneWithLocalPath", "");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void playMusicByLocalPath(String localPath, boolean looping, boolean enableAudioFocus, IMusicListener listener) {
        try {
            this.mSkill.playMusicByLocalPath(localPath, looping, enableAudioFocus, listener);
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("localPath", localPath);
            param.put("looping", looping);
            param.put("enableAudioFocus", enableAudioFocus);
            OrionBase.logApi(2, "playMusicByLocalPath", SkillApi.getParamJsonObjectString(param));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void stopMusicPlay() {
        try {
            this.mSkill.stopMusicPlay();
            OrionBase.logApi(2, "stopMusicPlay", "");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void stopTTS() {
        try {
            this.mSkill.stopTTS();
            OrionBase.logApi(2, "stopTTS", "");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void switchScene(SceneEntity scene) {
        try {
            this.mSkill.switchScene(scene);
            OrionBase.logApi(2, "switchScene", scene.toString());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void stopTone() {
        try {
            this.mSkill.stopTone();
            OrionBase.logApi(2, "stopTone", "");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void cancleAudioOperation() {
        try {
            this.mSkill.cancleAudioOperation();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setRecognizeMode(boolean isContinue) {
        try {
            this.mSkill.setRecognizeMode(isContinue);
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("isContinue", isContinue);
            OrionBase.logApi(2, "setRecognizeMode", SkillApi.getParamJsonObjectString(param));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void setASREnabled(boolean enable) {
        try {
            this.mSkill.setASREnabled(enable);
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("enable", enable);
            OrionBase.logApi(2, "setASREnabled", SkillApi.getParamJsonObjectString(param));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setRecognizable(boolean enable) {
        try {
            this.mSkill.setRecognizable(enable);
            HashMap<String, Object> param = new HashMap<String, Object>(1);
            param.put("enable", enable);
            OrionBase.logApi(2, "setRecognizable", SkillApi.getParamJsonObjectString(param));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void queryByText(String text) {
        OrionBase.logApi(2, "queryByText", "");
        try {
            this.mSkill.queryByText(text);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void getActiveAsk(String properType, String robotProperJson) {
        try {
            this.mSkill.getActiveAsk(properType, robotProperJson);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean setAsrExtendProperty(String propertyJson) {
        try {
            return this.mSkill.setAsrExtendProperty(propertyJson);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setAngleCenterRange(float angle_center, float angle_range) {
        try {
            this.mSkill.setAngleCenterRange(angle_center, angle_range);
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("angle_center", Float.valueOf(angle_center));
            param.put("angle_range", Float.valueOf(angle_range));
            OrionBase.logApi(2, "setAngleCenterRange", SkillApi.getParamJsonObjectString(param));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setMultipleModeEnable(boolean enale) {
        HashMap<String, Object> param = new HashMap<String, Object>(1);
        param.put("enale", enale);
        OrionBase.logApi(2, "setMultipleModeEnable", SkillApi.getParamJsonObjectString(param));
        try {
            this.mSkill.setMultipleModeEnable(enale);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    public int setCustomizeWakeUpWord(String wakeUpWordChinese, String wakeUpWordPinYin, String separator) {
        OrionBase.logApi(2, "setCustomizeWakeUpWord", "");
        try {
            return this.mSkill.setCustomizeWakeUpWord(wakeUpWordChinese, wakeUpWordPinYin, separator);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            return -1;
        }
    }

    public int closeCustomizeWakeUpWord() {
        OrionBase.logApi(2, "closeCustomizeWakeUpWord", "");
        try {
            return this.mSkill.closeCustomizeWakeUpWord();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            return -1;
        }
    }

    public int getPinYinScore(String pinyin, String separator) {
        OrionBase.logApi(2, "getPinYinScore", "");
        try {
            return this.mSkill.getPinYinScore(pinyin, separator);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            return -1;
        }
    }

    public String queryPinYinFromChinese(String chineseWord) {
        OrionBase.logApi(2, "queryPinYinFromChinese", "");
        try {
            return this.mSkill.queryPinYinFromChinese(chineseWord);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    public String queryPinYinMappingTable(String pinyin) {
        OrionBase.logApi(2, "queryPinYinMappingTable", "");
        try {
            return this.mSkill.queryPinYinMappingTable(pinyin);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    public String queryUserSetWakeUpWord() {
        OrionBase.logApi(2, "queryUserSetWakeUpWord", "");
        try {
            return this.mSkill.queryUserSetWakeUpWord();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    public void setLangRec(LangJson langJson) {
        try {
            if (null != langJson) {
                this.mSkill.setLangRec(new Gson().toJson((Object)langJson));
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    public void setASRParams(@ASRParams String asrType, String value) {
        try {
            this.mSkill.setASRParams(asrType, value);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
        }
    }

    private static String getParamJsonObjectString(Map<String, Object> map) {
        try {
            JSONObject param = new JSONObject();
            if (map != null) {
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    param.put(entry.getKey(), entry.getValue());
                }
            }
            return param.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void registerServerCheck(SkillServerCheckListener listener) {
        try {
            this.mSkill.registerServerCheck(listener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void unregisterServerCheck() {
        try {
            this.mSkill.unregisterServerCheck();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void onCreate(String app_id) {
        try {
            this.mSkill.onCreate(app_id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void onForeground(String app_id) {
        try {
            this.mSkill.onForeground(app_id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void onBackground(String app_id) {
        try {
            this.mSkill.onBackground(app_id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void onDestroy(String app_id) {
        try {
            this.mSkill.onDestroy(app_id);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setVersion(String app_id, String app_version) {
        try {
            this.mSkill.setVersion(app_id, app_version);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setPath(String app_id, String path) {
        try {
            this.mSkill.setPath(app_id, path);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setSyncReportCustomNlpData(String app_id, String data) {
        try {
            this.mSkill.setSyncReportCustomNlpData(app_id, data);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setAsyncReportCustomNlpData(String app_id, String data) {
        try {
            this.mSkill.setAsyncReportCustomNlpData(app_id, data);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void resetNlpState() {
        try {
            this.mSkill.resetNlpState();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setServerApp(List<String> appList) {
        try {
            this.mSkill.setServerApp(appList);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setDebug(boolean value) {
        try {
            this.mSkill.setDebug(value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setSyncCustomNlpData(Map<String, Object> map) {
        try {
            this.mSkill.setSyncCustomNlpData(map);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public String setAsyncCustomNlpData(String opt, String data) {
        try {
            return this.mSkill.setAsyncCustomNlpData(opt, data);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "error";
        }
    }

    public int getTtsPlayStatus() {
        OrionBase.logApi(2, "getTtsPlayStatus", "");
        try {
            return this.mSkill.getTtsPlayStatus();
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)Log.getStackTraceString((Throwable)e));
            return -1;
        }
    }
}

