/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.robotsetting;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.base.OrionBase;
import com.ainirobot.coreservice.IRobotBinderPool;
import com.ainirobot.coreservice.IRobotSettingApi;
import com.ainirobot.coreservice.client.BaseSubApi;
import com.ainirobot.coreservice.client.ProductInfo;
import com.ainirobot.coreservice.client.messagedispatcher.RobotSettingDispatcher;
import com.ainirobot.coreservice.client.robotsetting.RobotSettingListener;
import java.util.ArrayList;
import java.util.Arrays;

public class RobotSettingApi
extends BaseSubApi {
    public static final String TAG = RobotSettingApi.class.getSimpleName();
    private static RobotSettingApi instance;
    private IRobotSettingApi mApi;

    private RobotSettingApi() {
        this.startNewThread(TAG);
    }

    public static synchronized RobotSettingApi getInstance() {
        if (instance == null) {
            instance = new RobotSettingApi();
        }
        return instance;
    }

    @Override
    public void onConnect(IRobotBinderPool robotBinderPool, Context context) {
        Log.i((String)TAG, (String)"on connect");
        try {
            this.mApi = IRobotSettingApi.Stub.asInterface(robotBinderPool.queryBinder(4, null));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        String zone = RobotSettingApi.getInstance().getRobotString("robot_settings_cloud_server_zone");
        OrionBase.setDomainEnv(ProductInfo.isOverSea(), zone, RobotSettingApi.getInstance().getRobotInt("robot_setting_system_environment") == 1);
    }

    public boolean containsRobotConfig(String key) {
        if (TextUtils.isEmpty((CharSequence)key) || null == this.mApi) {
            return false;
        }
        try {
            return this.mApi.containsRobotConfig(key);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hasRobotSetting(String key) {
        if (TextUtils.isEmpty((CharSequence)key) || null == this.mApi) {
            return false;
        }
        try {
            return this.mApi.hasRobotSetting(key);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getRobotInt(String key) {
        String value = this.getRobotString(key);
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public float getRobotFloat(String key) {
        String value = this.getRobotString(key);
        try {
            return Float.valueOf(value).floatValue();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public String getRobotString(String key) {
        if (TextUtils.isEmpty((CharSequence)key) || null == this.mApi) {
            return "";
        }
        try {
            return this.mApi.getRobotSetting(key);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setRobotInt(String key, int value) {
        this.setRobotString(key, String.valueOf(value));
    }

    public void setRobotFloat(String key, float value) {
        this.setRobotString(key, String.valueOf(value));
    }

    public void setRobotString(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)key) || null == this.mApi) {
            return;
        }
        try {
            this.mApi.setRobotSetting(key, value);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void registerRobotSettingListener(RobotSettingListener listener, String ... key) {
        if (null == listener || key.length == 0 || null == this.mApi) {
            return;
        }
        ArrayList<String> keyList = new ArrayList<String>(Arrays.asList(key));
        try {
            RobotSettingDispatcher dispatcher;
            if (null != listener.getDispatcher()) {
                dispatcher = listener.getDispatcher();
                for (String oldKey : listener.getKeyList()) {
                    if (keyList.contains(oldKey)) continue;
                    keyList.add(oldKey);
                }
            } else {
                dispatcher = null == this.mHandlerThread ? this.mMessageDispatcher.obtainRobotSettingDispatcher(listener) : this.mMessageDispatcher.obtainRobotSettingDispatcher(this.mHandlerThread.getLooper(), listener);
            }
            listener.onRegistered(dispatcher, keyList);
            this.mApi.registerRobotSettingListener(keyList, dispatcher);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void unRegisterRobotSettingListener(RobotSettingListener listener) {
        if (null == listener || null == listener.getDispatcher() || this.mApi == null) {
            return;
        }
        try {
            this.mApi.unregisterRobotSettingListener(listener.getDispatcher());
            listener.onUnRegistered();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

