/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.person;

import android.text.TextUtils;
import com.ainirobot.coreservice.client.listener.Person;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PersonUtils {
    public static List<Person> getAllFaces(List<Person> personList) {
        if (null == personList || personList.size() <= 0) {
            return null;
        }
        CopyOnWriteArrayList<Person> allFaceList = new CopyOnWriteArrayList<Person>();
        for (Person person : personList) {
            if (!person.isWithFace()) continue;
            allFaceList.add(person);
        }
        return allFaceList;
    }

    public static List<Person> getAllCompleteFaces(List<Person> personList) {
        if (null == personList || personList.size() <= 0) {
            return null;
        }
        CopyOnWriteArrayList<Person> completeFaceList = new CopyOnWriteArrayList<Person>();
        for (Person person : personList) {
            if (!PersonUtils.isCompleteFace(person)) continue;
            completeFaceList.add(person);
        }
        return completeFaceList;
    }

    public static List<Person> getAllBodys(List<Person> personList) {
        if (null == personList || personList.size() <= 0) {
            return null;
        }
        CopyOnWriteArrayList<Person> bodyList = new CopyOnWriteArrayList<Person>();
        for (Person person : personList) {
            if (!PersonUtils.isBody(person)) continue;
            if (!PersonUtils.isFace(person)) {
                person.setId(-1);
            }
            bodyList.add(person);
        }
        return bodyList;
    }

    public static Person getBestFace(List<Person> list) {
        if (list == null || list.size() <= 0) {
            return null;
        }
        Person person = null;
        for (Person newPerson : list) {
            double distance = newPerson.getDistance();
            double faceAngelX = newPerson.getFaceAngleX();
            if (!PersonUtils.isFace(newPerson)) continue;
            if (person == null || person.getDistance() > distance) {
                person = newPerson;
                continue;
            }
            if (person.getDistance() != distance || !(Math.abs(person.getFaceAngleX()) > Math.abs(faceAngelX))) continue;
            person = newPerson;
        }
        return person;
    }

    public static Person getBestFace(List<Person> list, double maxDistance, double maxFaceAngelX) {
        if (list == null || list.size() <= 0) {
            return null;
        }
        Person person = null;
        for (Person newPerson : list) {
            double distance = newPerson.getDistance();
            double faceAngelX = newPerson.getFaceAngleX();
            if (!PersonUtils.isFace(newPerson) || !(distance <= maxDistance) || !(Math.abs(faceAngelX) <= Math.abs(maxFaceAngelX))) continue;
            if (person == null || person.getDistance() > distance) {
                person = newPerson;
                continue;
            }
            if (person.getDistance() != distance || !(Math.abs(person.getFaceAngleX()) > Math.abs(faceAngelX))) continue;
            person = newPerson;
        }
        return person;
    }

    public static Person getBestBody(List<Person> list, double maxDistance) {
        if (list == null || list.size() <= 0) {
            return null;
        }
        Person person = null;
        for (Person newPerson : list) {
            double distance = newPerson.getDistance();
            double faceAngelX = newPerson.getFaceAngleX();
            if (!PersonUtils.isBody(newPerson) || !(distance <= maxDistance)) continue;
            if (!PersonUtils.isFace(newPerson)) {
                newPerson.setId(-1);
            }
            if (person == null || person.getDistance() > distance) {
                person = newPerson;
                continue;
            }
            if (person.getDistance() != distance || !(Math.abs(person.getFaceAngleX()) > Math.abs(faceAngelX))) continue;
            person = newPerson;
        }
        return person;
    }

    public static List<Person> getPersonList(List<Person> personList, double maxDistance) {
        if (personList == null || personList.size() <= 0) {
            return null;
        }
        CopyOnWriteArrayList<Person> newPersonList = new CopyOnWriteArrayList<Person>();
        for (Person person : personList) {
            if (!(person.getDistance() <= maxDistance)) continue;
            newPersonList.add(person);
        }
        return newPersonList;
    }

    public static String parseRegisterName(String params) {
        String name = "";
        if (TextUtils.isEmpty((CharSequence)params) || "[]".equals(params) || "{}".equals(params)) {
            return name;
        }
        try {
            JSONArray start;
            JSONObject jsonObject = new JSONObject(params);
            String slots = jsonObject.optString("slots");
            if (!(TextUtils.isEmpty((CharSequence)slots) || "[]".equals(slots) || "{}".equals(slots) || (start = new JSONObject(slots).optJSONArray("start")) == null)) {
                JSONObject jsonObj = start.getJSONObject(0);
                name = jsonObj.optString("value");
            }
            return name;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return name;
        }
    }

    public static Person getSpecialPerson(List<Person> personList, int personId) {
        if (personList == null || personList.size() <= 0) {
            return null;
        }
        for (Person newPerson : personList) {
            if (newPerson.getId() != personId) continue;
            return newPerson;
        }
        return null;
    }

    public static boolean isFace(Person person) {
        return person.isWithFace();
    }

    public static boolean isCompleteFace(Person person) {
        return person.getId() >= 0 && person.isWithFace() && !person.isOtherFace();
    }

    public static boolean isBody(Person person) {
        return person.isWithBody();
    }
}

