/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.person;

import android.content.Context;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.ainirobot.coreservice.IPersonApi;
import com.ainirobot.coreservice.IRobotBinderPool;
import com.ainirobot.coreservice.client.BaseSubApi;
import com.ainirobot.coreservice.client.listener.CommandListener;
import com.ainirobot.coreservice.client.listener.Person;
import com.ainirobot.coreservice.client.messagedispatcher.ActionDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.PersonDispatcher;
import com.ainirobot.coreservice.client.person.PersonListener;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.List;

public class PersonApi
extends BaseSubApi {
    private static final String TAG = PersonApi.class.getSimpleName();
    private static PersonApi instance;
    private IPersonApi mApi;
    private Gson mGson;
    private final ArrayList<PersonListener> mPersonListenerList = new ArrayList();
    private PersonListener mPersonListener;
    private boolean mIsReconnect = false;

    private PersonApi() {
        this.mGson = new Gson();
        this.startNewThread(TAG);
    }

    public static synchronized PersonApi getInstance() {
        if (instance == null) {
            instance = new PersonApi();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnect(IRobotBinderPool pool, Context context) {
        try {
            this.mApi = IPersonApi.Stub.asInterface(pool.queryBinder(3, context.getPackageName()));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (this.mIsReconnect) {
            ArrayList<PersonListener> arrayList = this.mPersonListenerList;
            synchronized (arrayList) {
                if (this.mPersonListenerList.size() > 0) {
                    try {
                        Log.d((String)TAG, (String)"register person listener");
                        PersonDispatcher personDispatcher = this.mMessageDispatcher.obtainPersonDispatcher(this.mHandlerThread.getLooper(), this.mPersonListener);
                        this.mApi.setPersonListener(personDispatcher);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.mIsReconnect = false;
        }
    }

    @Override
    public void onDisconnect() {
        this.mIsReconnect = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerPersonListener(PersonListener listener) {
        if (this.mApi == null || listener == null) {
            return false;
        }
        if (this.mPersonListener == null) {
            this.mPersonListener = new PersonListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void personChanged() {
                    ArrayList arrayList = PersonApi.this.mPersonListenerList;
                    synchronized (arrayList) {
                        for (PersonListener listenerItem : PersonApi.this.mPersonListenerList) {
                            listenerItem.personChanged();
                        }
                    }
                }
            };
        }
        ArrayList<PersonListener> arrayList = this.mPersonListenerList;
        synchronized (arrayList) {
            if (this.mPersonListenerList.contains(listener)) {
                return true;
            }
            this.mPersonListenerList.add(listener);
            try {
                Log.d((String)TAG, (String)"register person listener");
                PersonDispatcher personDispatcher = this.mMessageDispatcher.obtainPersonDispatcher(this.mHandlerThread.getLooper(), this.mPersonListener);
                return this.mApi.setPersonListener(personDispatcher);
            }
            catch (RemoteException e) {
                e.printStackTrace();
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPersonListener(PersonListener listener) {
        if (this.mApi == null || listener == null) {
            return;
        }
        ArrayList<PersonListener> arrayList = this.mPersonListenerList;
        synchronized (arrayList) {
            if (this.mPersonListenerList.remove(listener) && this.mPersonListenerList.size() == 0) {
                try {
                    Log.d((String)TAG, (String)"unregister person listener");
                    this.mApi.releasePersonListener();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public List<Person> getAllPersons() {
        if (this.mApi == null) {
            return null;
        }
        try {
            return this.getPersonListFromString(this.mApi.getAllPersons());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Person> getAllPersons(double maxDistance) {
        if (this.mApi == null) {
            return null;
        }
        try {
            return this.getPersonListFromString(this.mApi.getAllPersonsByDistance(maxDistance));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Person> getAllFaceList() {
        if (this.mApi == null) {
            return null;
        }
        try {
            return this.getPersonListFromString(this.mApi.getAllFaceList());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Person> getAllFaceList(double maxDistance) {
        if (this.mApi == null) {
            return null;
        }
        try {
            return this.getPersonListFromString(this.mApi.getAllFaceListByDistance(maxDistance));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Person> getCompleteFaceList() {
        if (this.mApi == null) {
            return null;
        }
        try {
            return this.getPersonListFromString(this.mApi.getCompleteFaceList());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Person> getCompleteFaceList(double maxDistance) {
        if (this.mApi == null) {
            return null;
        }
        try {
            return this.getPersonListFromString(this.mApi.getCompleteFaceListByDistance(maxDistance));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Person> getAllBodyList() {
        if (this.mApi == null) {
            return null;
        }
        try {
            return this.getPersonListFromString(this.mApi.getAllBodyList());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<Person> getAllBodyList(double maxDistance) {
        if (this.mApi == null) {
            return null;
        }
        try {
            return this.getPersonListFromString(this.mApi.getAllBodyListByDistance(maxDistance));
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Person getFocusPerson() {
        if (this.mApi == null) {
            return null;
        }
        try {
            return this.getPersonFromString(this.mApi.getFocusPerson());
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean registerById(int personId, String name, CommandListener listener) {
        if (this.mApi == null) {
            return false;
        }
        try {
            ActionDispatcher actionListener = this.mMessageDispatcher.obtainActionDispatcher(this.mHandlerThread.getLooper(), listener);
            return this.mApi.registerById(personId, name, actionListener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean registerByPic(String picturePath, String name, CommandListener listener) {
        if (this.mApi == null) {
            return false;
        }
        try {
            ActionDispatcher actionListener = this.mMessageDispatcher.obtainActionDispatcher(this.mHandlerThread.getLooper(), listener);
            return this.mApi.registerByPic(picturePath, name, actionListener);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean recognizeById(int personId, CommandListener listener) {
        if (this.mApi == null) {
            return false;
        }
        try {
            ActionDispatcher dispatcher = this.mMessageDispatcher.obtainActionDispatcher(this.mHandlerThread.getLooper(), listener);
            return this.mApi.recognizeById(personId, dispatcher);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean recognizeByPic(String picturePath, CommandListener listener) {
        if (this.mApi == null) {
            return false;
        }
        try {
            ActionDispatcher dispatcher = this.mMessageDispatcher.obtainActionDispatcher(this.mHandlerThread.getLooper(), listener);
            return this.mApi.recognizeByPic(picturePath, dispatcher);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getMultipleModeInfos(int index) {
        if (this.mApi == null) {
            return null;
        }
        try {
            return this.mApi.getMultipleModeInfos(index);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private Person getPersonFromString(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return null;
        }
        return (Person)this.mGson.fromJson(message, new TypeToken<Person>(){}.getType());
    }

    private List<Person> getPersonListFromString(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return null;
        }
        return (List)this.mGson.fromJson(message, new TypeToken<List<Person>>(){}.getType());
    }
}

