/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.permission;

import android.content.Context;
import android.content.Intent;
import android.os.RemoteException;
import android.util.Log;
import com.ainirobot.coreservice.IPermissionApi;
import com.ainirobot.coreservice.IRobotBinderPool;
import com.ainirobot.coreservice.client.BaseSubApi;
import com.ainirobot.coreservice.client.messagedispatcher.PermissionDispatcher;
import com.ainirobot.coreservice.client.permission.PermissionListener;
import java.util.ArrayList;

public class PermissionApi
extends BaseSubApi {
    private static final String TAG = PermissionApi.class.getSimpleName();
    private static PermissionApi instance;
    private IPermissionApi mApi;
    private final ArrayList<PermissionListener> mPermissionListenerList = new ArrayList();
    private PermissionListener mPermissionListener;

    private PermissionApi() {
        Log.i((String)TAG, (String)"PermissionApi create");
        this.startNewThread(TAG);
    }

    public static synchronized PermissionApi getInstance() {
        if (null == instance) {
            instance = new PermissionApi();
        }
        return instance;
    }

    @Override
    public void onConnect(IRobotBinderPool robotBinderPool, Context context) {
        Log.i((String)TAG, (String)"PermissionApi start connect");
        try {
            this.mApi = IPermissionApi.Stub.asInterface(robotBinderPool.queryBinder(10, null));
            Log.i((String)TAG, (String)"PermissionApi connect success");
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerPermissionListener(PermissionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mPermissionListener == null) {
            this.mPermissionListener = new PermissionListener(){

                @Override
                public void activityStarting(Intent intent, String pkg) {
                    for (PermissionListener listenerItem : PermissionApi.this.mPermissionListenerList) {
                        listenerItem.activityStarting(intent, pkg);
                    }
                }

                @Override
                public void activityResuming(String pkg) {
                    for (PermissionListener listenerItem : PermissionApi.this.mPermissionListenerList) {
                        listenerItem.activityResuming(pkg);
                    }
                }

                @Override
                public void appCrashed(String processName, int pid, String shortMsg, String longMsg, long timeMillis, String stackTrace) {
                    for (PermissionListener listenerItem : PermissionApi.this.mPermissionListenerList) {
                        listenerItem.appCrashed(processName, pid, shortMsg, longMsg, timeMillis, stackTrace);
                    }
                }

                @Override
                public void appEarlyNotResponding(String processName, int pid, String annotation) {
                    for (PermissionListener listenerItem : PermissionApi.this.mPermissionListenerList) {
                        listenerItem.appEarlyNotResponding(processName, pid, annotation);
                    }
                }

                @Override
                public void appNotResponding(String processName, int pid, String processStats) {
                    for (PermissionListener listenerItem : PermissionApi.this.mPermissionListenerList) {
                        listenerItem.appNotResponding(processName, pid, processStats);
                    }
                }

                @Override
                public void systemNotResponding(String msg) {
                    for (PermissionListener listenerItem : PermissionApi.this.mPermissionListenerList) {
                        listenerItem.systemNotResponding(msg);
                    }
                }

                @Override
                public void onForegroundActivitiesChanged(int pid, int uid, boolean foregroundActivities) {
                    for (PermissionListener listenerItem : PermissionApi.this.mPermissionListenerList) {
                        listenerItem.onForegroundActivitiesChanged(pid, uid, foregroundActivities);
                    }
                }

                @Override
                public void onProcessDied(int pid, int uid) {
                    for (PermissionListener listenerItem : PermissionApi.this.mPermissionListenerList) {
                        listenerItem.onProcessDied(pid, uid);
                    }
                }
            };
        }
        ArrayList<PermissionListener> arrayList = this.mPermissionListenerList;
        synchronized (arrayList) {
            if (this.mPermissionListenerList.contains(listener)) {
                return;
            }
            this.mPermissionListenerList.add(listener);
            try {
                Log.d((String)TAG, (String)"register permission listener");
                PermissionDispatcher permissionDispatcher = this.mMessageDispatcher.obtainPermissionDispatcher(this.mHandlerThread.getLooper(), this.mPermissionListener);
                this.mApi.registerPermissionListener(permissionDispatcher);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterPermissionListener(PermissionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.mPermissionListener == null) {
            return;
        }
        ArrayList<PermissionListener> arrayList = this.mPermissionListenerList;
        synchronized (arrayList) {
            if (this.mPermissionListenerList.remove(listener) && this.mPermissionListenerList.size() == 0) {
                try {
                    Log.d((String)TAG, (String)"unregister permission listener");
                    PermissionDispatcher permissionDispatcher = this.mMessageDispatcher.obtainPermissionDispatcher(this.mHandlerThread.getLooper(), this.mPermissionListener);
                    this.mApi.unregisterPermissionListener(permissionDispatcher);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

