/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import com.ainirobot.coreservice.client.listener.ToneListener;
import com.ainirobot.coreservice.client.messagedispatcher.DispatchHandler;
import com.ainirobot.coreservice.client.messagedispatcher.IRecyclable;
import com.ainirobot.coreservice.client.messagedispatcher.RecyclablePool;
import com.ainirobot.coreservice.client.messagedispatcher.ToneMessage;
import com.ainirobot.coreservice.listener.IToneListener;

public class ToneDispatcher
extends IToneListener.Stub
implements IRecyclable {
    private static final String TAG = ToneDispatcher.class.getSimpleName();
    private static RecyclablePool<ToneDispatcher> sPool = new RecyclablePool();
    private DispatchHandler mDispatchHandler;
    private ToneListener mListener;

    private ToneDispatcher(DispatchHandler dispatchHandler, ToneListener listener) {
        this.mDispatchHandler = dispatchHandler;
        this.mListener = listener;
    }

    static ToneDispatcher obtain(DispatchHandler dispatchHandler, ToneListener listener) {
        ToneDispatcher toneDispatcher = sPool.obtain();
        if (toneDispatcher == null) {
            toneDispatcher = new ToneDispatcher(dispatchHandler, listener);
        } else {
            toneDispatcher.mDispatchHandler = dispatchHandler;
            toneDispatcher.mListener = listener;
        }
        return toneDispatcher;
    }

    @Override
    public void onStart() {
        ToneListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            ToneMessage toneMessage = new ToneMessage(1, listener);
            handler.sendMessage(handler.obtainMessage(4, toneMessage));
        }
    }

    @Override
    public void onStop() {
        ToneListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            ToneMessage toneMessage = new ToneMessage(2, listener);
            handler.sendMessage(handler.obtainMessage(4, toneMessage));
        }
        sPool.recycle(this);
    }

    @Override
    public void onError() {
        ToneListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            ToneMessage toneMessage = new ToneMessage(3, listener);
            handler.sendMessage(handler.obtainMessage(4, toneMessage));
        }
        sPool.recycle(this);
    }

    @Override
    public void onComplete() {
        ToneListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            ToneMessage toneMessage = new ToneMessage(4, listener);
            handler.sendMessage(handler.obtainMessage(4, toneMessage));
        }
        sPool.recycle(this);
    }

    @Override
    public void recycle() {
        this.mDispatchHandler = null;
        this.mListener = null;
    }
}

