/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import com.ainirobot.coreservice.client.listener.TextListener;
import com.ainirobot.coreservice.client.messagedispatcher.DispatchHandler;
import com.ainirobot.coreservice.client.messagedispatcher.IRecyclable;
import com.ainirobot.coreservice.client.messagedispatcher.RecyclablePool;
import com.ainirobot.coreservice.client.messagedispatcher.TextMessage;
import com.ainirobot.coreservice.listener.ITextListener;

public class TextDispatcher
extends ITextListener.Stub
implements IRecyclable {
    private static final String TAG = TextDispatcher.class.getSimpleName();
    private static RecyclablePool<TextDispatcher> sPool = new RecyclablePool();
    private DispatchHandler mDispatchHandler;
    private TextListener mListener;

    private TextDispatcher(DispatchHandler dispatchHandler, TextListener listener) {
        this.mDispatchHandler = dispatchHandler;
        this.mListener = listener;
    }

    static TextDispatcher obtain(DispatchHandler dispatchHandler, TextListener listener) {
        TextDispatcher textDispatcher = sPool.obtain();
        if (textDispatcher == null) {
            textDispatcher = new TextDispatcher(dispatchHandler, listener);
        } else {
            textDispatcher.mDispatchHandler = dispatchHandler;
            textDispatcher.mListener = listener;
        }
        return textDispatcher;
    }

    @Override
    public void onStart() {
        TextListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            TextMessage textMessage = new TextMessage(1, listener);
            handler.sendMessage(handler.obtainMessage(3, textMessage));
        }
    }

    @Override
    public void onStop() {
        TextListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            TextMessage textMessage = new TextMessage(2, listener);
            handler.sendMessage(handler.obtainMessage(3, textMessage));
        }
        sPool.recycle(this);
    }

    @Override
    public void onError() {
        TextListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            TextMessage textMessage = new TextMessage(3, listener);
            handler.sendMessage(handler.obtainMessage(3, textMessage));
        }
        sPool.recycle(this);
    }

    @Override
    public void onComplete() {
        TextListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            TextMessage textMessage = new TextMessage(4, listener);
            handler.sendMessage(handler.obtainMessage(3, textMessage));
        }
        sPool.recycle(this);
    }

    @Override
    public void recycle() {
        this.mDispatchHandler = null;
        this.mListener = null;
    }
}

