/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import com.ainirobot.coreservice.client.messagedispatcher.IMsgHandle;
import com.ainirobot.coreservice.client.messagedispatcher.IRecyclable;
import com.ainirobot.coreservice.client.messagedispatcher.RecyclablePool;
import com.ainirobot.coreservice.client.surfaceshare.SurfaceShareListener;

class SurfaceShareMessage
implements IMsgHandle,
IRecyclable {
    private static RecyclablePool<SurfaceShareMessage> sPool = new RecyclablePool();
    MsgType msgType;
    String msgStr;
    SurfaceShareListener msgListener;
    int msgCode;

    @Override
    public void handleMessage() {
        switch (this.msgType) {
            case error: {
                this.msgListener.onError(this.msgCode, this.msgStr);
                break;
            }
            case status: {
                this.msgListener.onStatusUpdate(this.msgCode, this.msgStr);
            }
        }
        sPool.recycle(this);
    }

    @Override
    public void recycle() {
        this.msgStr = null;
        this.msgListener = null;
    }

    private SurfaceShareMessage(SurfaceShareListener msgListener, MsgType msgType, String msgStr, int msgCode) {
        this.msgCode = msgCode;
        this.msgStr = msgStr;
        this.msgType = msgType;
        this.msgListener = msgListener;
    }

    static SurfaceShareMessage obtain(SurfaceShareListener msgListener, MsgType msgType, String msgStr, int msgCode) {
        SurfaceShareMessage message = sPool.obtain();
        if (message == null) {
            message = new SurfaceShareMessage(msgListener, msgType, msgStr, msgCode);
        } else {
            message.msgType = msgType;
            message.msgStr = msgStr;
            message.msgCode = msgCode;
            message.msgListener = msgListener;
        }
        return message;
    }

    static enum MsgType {
        error,
        status;

    }
}

