/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import android.os.RemoteException;
import android.util.Log;
import com.ainirobot.coreservice.client.messagedispatcher.DispatchHandler;
import com.ainirobot.coreservice.client.messagedispatcher.IRecyclable;
import com.ainirobot.coreservice.client.messagedispatcher.RecyclablePool;
import com.ainirobot.coreservice.client.messagedispatcher.SurfaceShareMessage;
import com.ainirobot.coreservice.client.surfaceshare.SurfaceShareListener;
import com.ainirobot.coreservice.listener.ISurfaceShareListener;

public class SurfaceShareDispatcher
extends ISurfaceShareListener.Stub
implements IRecyclable {
    private static final String TAG = SurfaceShareDispatcher.class.getSimpleName();
    private static RecyclablePool<SurfaceShareDispatcher> sPool = new RecyclablePool();
    private DispatchHandler mDispatchHandler;
    private SurfaceShareListener mListener;

    private SurfaceShareDispatcher(DispatchHandler dispatchHandler, SurfaceShareListener listener) {
        this.mDispatchHandler = dispatchHandler;
        this.mListener = listener;
    }

    static SurfaceShareDispatcher obtain(DispatchHandler dispatchHandler, SurfaceShareListener listener) {
        SurfaceShareDispatcher dispatcher = sPool.obtain();
        if (dispatcher == null) {
            dispatcher = new SurfaceShareDispatcher(dispatchHandler, listener);
        } else {
            dispatcher.mDispatchHandler = dispatchHandler;
            dispatcher.mListener = listener;
        }
        return dispatcher;
    }

    @Override
    public void onError(int errorCode, String errorString) throws RemoteException {
        DispatchHandler dispatchHandler = this.mDispatchHandler;
        SurfaceShareListener listener = this.mListener;
        if (dispatchHandler != null && listener != null) {
            SurfaceShareMessage actionMessage = SurfaceShareMessage.obtain(listener, SurfaceShareMessage.MsgType.error, errorString, errorCode);
            dispatchHandler.sendMessage(dispatchHandler.obtainMessage(9, actionMessage));
            sPool.recycle(this);
        } else {
            Log.e((String)TAG, (String)("onError status = " + errorCode + "; data = " + errorString));
        }
    }

    @Override
    public void onStatusUpdate(int status, String data) throws RemoteException {
        DispatchHandler dispatchHandler = this.mDispatchHandler;
        SurfaceShareListener listener = this.mListener;
        if (dispatchHandler != null && listener != null) {
            SurfaceShareMessage actionMessage = SurfaceShareMessage.obtain(listener, SurfaceShareMessage.MsgType.status, data, status);
            dispatchHandler.sendMessage(dispatchHandler.obtainMessage(9, actionMessage));
        } else {
            Log.e((String)TAG, (String)("onStatusUpdate status = " + status + "; data = " + data));
        }
    }

    @Override
    public void recycle() {
        this.mDispatchHandler = null;
        this.mListener = null;
    }
}

