/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import android.os.RemoteException;
import com.ainirobot.coreservice.client.StatusListener;
import com.ainirobot.coreservice.client.messagedispatcher.IMsgHandle;
import com.ainirobot.coreservice.client.messagedispatcher.IRecyclable;
import com.ainirobot.coreservice.client.messagedispatcher.RecyclablePool;

class StatusMessage
implements IMsgHandle,
IRecyclable {
    private static RecyclablePool<StatusMessage> sPool = new RecyclablePool();
    private String type;
    private String data;
    private StatusListener listener;

    private StatusMessage(String type, String data, StatusListener listener) {
        this.type = type;
        this.data = data;
        this.listener = listener;
    }

    static StatusMessage obtain(String type, String data, StatusListener listener) {
        StatusMessage statusMessage = sPool.obtain();
        if (statusMessage == null) {
            statusMessage = new StatusMessage(type, data, listener);
        } else {
            statusMessage.type = type;
            statusMessage.data = data;
            statusMessage.listener = listener;
        }
        return statusMessage;
    }

    @Override
    public void recycle() {
        this.type = null;
        this.data = null;
        this.listener = null;
    }

    @Override
    public void handleMessage() {
        try {
            this.listener.onStatusUpdate(this.type, this.data);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        sPool.recycle(this);
    }
}

