/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.ainirobot.coreservice.IStatusListener;
import com.ainirobot.coreservice.client.StatusListener;
import com.ainirobot.coreservice.client.messagedispatcher.DispatchHandler;
import com.ainirobot.coreservice.client.messagedispatcher.IRecyclable;
import com.ainirobot.coreservice.client.messagedispatcher.RecyclablePool;
import com.ainirobot.coreservice.client.messagedispatcher.StatusMessage;
import java.util.concurrent.ConcurrentHashMap;

public class StatusDispatcher
extends IStatusListener.Stub
implements IRecyclable {
    private static RecyclablePool<StatusDispatcher> sPool = new RecyclablePool();
    private static ConcurrentHashMap<String, StatusDispatcher> sRegisterListener = new ConcurrentHashMap();
    private DispatchHandler mDispatchHandler;
    private StatusListener mListener;
    private String mId;

    private StatusDispatcher(DispatchHandler dispatchHandler, StatusListener listener) {
        this.mDispatchHandler = dispatchHandler;
        this.mListener = listener;
    }

    static StatusDispatcher obtain(DispatchHandler dispatchHandler, StatusListener listener) {
        StatusDispatcher actionDispatcher = sPool.obtain();
        if (actionDispatcher == null) {
            actionDispatcher = new StatusDispatcher(dispatchHandler, listener);
        } else {
            actionDispatcher.mDispatchHandler = dispatchHandler;
            actionDispatcher.mListener = listener;
        }
        return actionDispatcher;
    }

    static void unregister(@NonNull String id) {
        StatusDispatcher dispatcher;
        if (!TextUtils.isEmpty((CharSequence)id) && (dispatcher = sRegisterListener.remove(id)) != null) {
            sPool.recycle(dispatcher);
        }
    }

    public void register(@NonNull String id) {
        this.mId = id;
        this.mListener.setId(id);
        sRegisterListener.put(id, this);
    }

    @Override
    public void onStatusUpdate(String type, String data) throws RemoteException {
        StatusListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            StatusMessage statusMessage = StatusMessage.obtain(type, data, listener);
            handler.sendMessage(handler.obtainMessage(2, statusMessage));
        }
    }

    @Override
    public void recycle() {
        this.mDispatchHandler = null;
        this.mListener = null;
        this.mId = null;
    }
}

