/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import com.ainirobot.coreservice.client.messagedispatcher.DispatchHandler;
import com.ainirobot.coreservice.client.messagedispatcher.IRecyclable;
import com.ainirobot.coreservice.client.messagedispatcher.RecyclablePool;
import com.ainirobot.coreservice.client.messagedispatcher.RobotSettingMessage;
import com.ainirobot.coreservice.client.robotsetting.RobotSettingListener;
import com.ainirobot.coreservice.listener.IRobotSettingListener;

public class RobotSettingDispatcher
extends IRobotSettingListener.Stub
implements IRecyclable {
    private DispatchHandler mDispatchHandler;
    private RobotSettingListener mListener;
    private static RecyclablePool<RobotSettingDispatcher> sPool = new RecyclablePool();

    private RobotSettingDispatcher(DispatchHandler dispatchHandler, RobotSettingListener listener) {
        this.mDispatchHandler = dispatchHandler;
        this.mListener = listener;
    }

    static RobotSettingDispatcher obtain(DispatchHandler dispatchHandler, RobotSettingListener listener) {
        RobotSettingDispatcher robotSettingDispatcher = sPool.obtain();
        if (robotSettingDispatcher == null) {
            robotSettingDispatcher = new RobotSettingDispatcher(dispatchHandler, listener);
        } else {
            robotSettingDispatcher.mDispatchHandler = dispatchHandler;
            robotSettingDispatcher.mListener = listener;
        }
        return robotSettingDispatcher;
    }

    @Override
    public void recycle() {
        this.mDispatchHandler = null;
        this.mListener = null;
    }

    @Override
    public void onRobotSettingChanged(String key) {
        if (this.mListener != null && this.mDispatchHandler != null) {
            RobotSettingMessage message = new RobotSettingMessage(key, this.mListener);
            this.mDispatchHandler.sendMessage(this.mDispatchHandler.obtainMessage(6, message));
        }
    }

    @Override
    public void onUnregister() {
        this.recycle();
    }
}

