/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import android.support.annotation.NonNull;
import com.ainirobot.coreservice.client.messagedispatcher.IRecyclable;
import java.util.ArrayDeque;
import java.util.concurrent.locks.ReentrantLock;

class RecyclablePool<T extends IRecyclable> {
    private ArrayDeque<T> mPool = new ArrayDeque();
    private ReentrantLock mLock = new ReentrantLock();

    RecyclablePool() {
    }

    T obtain() {
        IRecyclable result;
        this.mLock.lock();
        try {
            result = (IRecyclable)this.mPool.poll();
        }
        finally {
            this.mLock.unlock();
        }
        return (T)result;
    }

    void recycle(@NonNull T recycleItem) {
        recycleItem.recycle();
        this.mLock.lock();
        try {
            if (!this.mPool.contains(recycleItem)) {
                this.mPool.add(recycleItem);
            }
        }
        finally {
            this.mLock.unlock();
        }
    }
}

