/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import android.content.Intent;
import com.ainirobot.coreservice.client.messagedispatcher.IMsgHandle;
import com.ainirobot.coreservice.client.permission.PermissionListener;

public class PermissionMessage
implements IMsgHandle {
    static final int TYPE_ACTIVITY_STARTING = 1;
    static final int TYPE_ACTIVITY_RESUMING = 2;
    static final int TYPE_APP_CRASHED = 3;
    static final int TYPE_APP_EARLY_NOT_RESPONDING = 4;
    static final int TYPE_APP_NOT_RESPONDING = 5;
    static final int TYPE_SYSTEM_NOT_RESPONDING = 6;
    static final int TYPE_FOREGROUND_ACTIVITIES_CHANGED = 7;
    static final int TYPE_PROCESS_DIED = 8;
    private int mType;
    private PermissionListener mListener;
    private Intent mIntent;
    private String mPackage;
    private int mPid;
    private int mUid;
    private String mProcessName;
    private boolean mForegroundActivities;
    private String mMsg;
    private String mMsg2;
    private long mTimeMillis;
    private String mStackTrace;

    PermissionMessage(int type, String processName, int pid, String shortMsg, String longMsg, long timeMillis, String stackTrace, PermissionListener listener) {
        this.mType = type;
        this.mProcessName = processName;
        this.mPid = pid;
        this.mMsg = shortMsg;
        this.mMsg2 = longMsg;
        this.mTimeMillis = timeMillis;
        this.mStackTrace = stackTrace;
        this.mListener = listener;
    }

    PermissionMessage(int type, int pid, int uid, boolean foregroundActivities, PermissionListener listener) {
        this.mType = type;
        this.mPid = pid;
        this.mUid = uid;
        this.mForegroundActivities = foregroundActivities;
        this.mListener = listener;
    }

    PermissionMessage(int type, String processName, int pid, String msg, PermissionListener listener) {
        this.mType = type;
        this.mProcessName = processName;
        this.mPid = pid;
        this.mMsg = msg;
        this.mListener = listener;
    }

    PermissionMessage(int type, Intent intent, String pkg, PermissionListener listener) {
        this.mType = type;
        this.mIntent = intent;
        this.mPackage = pkg;
        this.mListener = listener;
    }

    PermissionMessage(int type, String pkg, String msg, PermissionListener listener) {
        this.mType = type;
        this.mPackage = pkg;
        this.mMsg = msg;
        this.mListener = listener;
    }

    PermissionMessage(int type, String msg, PermissionListener listener) {
        this.mType = type;
        this.mMsg = msg;
        this.mListener = listener;
    }

    PermissionMessage(int type, int pid, int uid, PermissionListener listener) {
        this.mType = type;
        this.mPid = pid;
        this.mUid = uid;
        this.mListener = listener;
    }

    @Override
    public void handleMessage() {
        switch (this.mType) {
            case 1: {
                this.mListener.activityStarting(this.mIntent, this.mPackage);
                break;
            }
            case 2: {
                this.mListener.activityResuming(this.mPackage);
                break;
            }
            case 3: {
                this.mListener.appCrashed(this.mProcessName, this.mPid, this.mMsg, this.mMsg2, this.mTimeMillis, this.mStackTrace);
                break;
            }
            case 4: {
                this.mListener.appEarlyNotResponding(this.mProcessName, this.mPid, this.mMsg);
                break;
            }
            case 5: {
                this.mListener.appNotResponding(this.mProcessName, this.mPid, this.mMsg);
                break;
            }
            case 6: {
                this.mListener.systemNotResponding(this.mMsg);
                break;
            }
            case 7: {
                this.mListener.onForegroundActivitiesChanged(this.mPid, this.mUid, this.mForegroundActivities);
                break;
            }
            case 8: {
                this.mListener.onProcessDied(this.mPid, this.mUid);
                break;
            }
        }
    }
}

