/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import android.content.Intent;
import com.ainirobot.coreservice.client.messagedispatcher.DispatchHandler;
import com.ainirobot.coreservice.client.messagedispatcher.PermissionMessage;
import com.ainirobot.coreservice.client.permission.PermissionListener;
import com.ainirobot.coreservice.listener.IPermissionListener;

public class PermissionDispatcher
extends IPermissionListener.Stub {
    private DispatchHandler mDispatchHandler;
    private PermissionListener mListener;
    private static PermissionDispatcher permissionDispatcher;

    private PermissionDispatcher(DispatchHandler dispatchHandler, PermissionListener listener) {
        this.mDispatchHandler = dispatchHandler;
        this.mListener = listener;
    }

    private void changeListener(PermissionListener listener) {
        this.mListener = listener;
    }

    static synchronized PermissionDispatcher obtain(DispatchHandler dispatchHandler, PermissionListener listener) {
        if (permissionDispatcher == null) {
            permissionDispatcher = new PermissionDispatcher(dispatchHandler, listener);
        } else {
            permissionDispatcher.changeListener(listener);
        }
        return permissionDispatcher;
    }

    @Override
    public void activityStarting(Intent intent, String pkg) {
        PermissionListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            PermissionMessage permissionMessage = new PermissionMessage(1, intent, pkg, listener);
            handler.sendMessage(handler.obtainMessage(8, permissionMessage));
        }
    }

    @Override
    public void activityResuming(String pkg) {
        PermissionListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            PermissionMessage permissionMessage = new PermissionMessage(2, pkg, null, listener);
            handler.sendMessage(handler.obtainMessage(8, permissionMessage));
        }
    }

    @Override
    public void appCrashed(String processName, int pid, String shortMsg, String longMsg, long timeMillis, String stackTrace) {
        PermissionListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            PermissionMessage permissionMessage = new PermissionMessage(3, processName, pid, shortMsg, longMsg, timeMillis, stackTrace, listener);
            handler.sendMessage(handler.obtainMessage(8, permissionMessage));
        }
    }

    @Override
    public void appEarlyNotResponding(String processName, int pid, String annotation) {
        PermissionListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            PermissionMessage permissionMessage = new PermissionMessage(4, processName, pid, annotation, listener);
            handler.sendMessage(handler.obtainMessage(8, permissionMessage));
        }
    }

    @Override
    public void appNotResponding(String processName, int pid, String processStats) {
        PermissionListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            PermissionMessage permissionMessage = new PermissionMessage(5, processName, pid, processStats, listener);
            handler.sendMessage(handler.obtainMessage(8, permissionMessage));
        }
    }

    @Override
    public void systemNotResponding(String msg) {
        PermissionListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            PermissionMessage permissionMessage = new PermissionMessage(6, msg, listener);
            handler.sendMessage(handler.obtainMessage(8, permissionMessage));
        }
    }

    @Override
    public void onForegroundActivitiesChanged(int pid, int uid, boolean foregroundActivities) {
        PermissionListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            PermissionMessage permissionMessage = new PermissionMessage(7, pid, uid, foregroundActivities, listener);
            handler.sendMessage(handler.obtainMessage(8, permissionMessage));
        }
    }

    @Override
    public void onProcessDied(int pid, int uid) {
        PermissionListener listener = this.mListener;
        DispatchHandler handler = this.mDispatchHandler;
        if (listener != null && handler != null) {
            PermissionMessage permissionMessage = new PermissionMessage(8, pid, uid, listener);
            handler.sendMessage(handler.obtainMessage(8, permissionMessage));
        }
    }
}

