/*
 * Decompiled with CFR 0.152.
 */
package com.ainirobot.coreservice.client.messagedispatcher;

import android.os.Looper;
import com.ainirobot.coreservice.client.StatusListener;
import com.ainirobot.coreservice.client.account.AccountListener;
import com.ainirobot.coreservice.client.listener.ActionListener;
import com.ainirobot.coreservice.client.listener.TextListener;
import com.ainirobot.coreservice.client.listener.ToneListener;
import com.ainirobot.coreservice.client.messagedispatcher.AccountDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.ActionDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.DispatchHandler;
import com.ainirobot.coreservice.client.messagedispatcher.PermissionDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.PersonDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.RobotSettingDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.StatusDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.SurfaceShareDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.TextDispatcher;
import com.ainirobot.coreservice.client.messagedispatcher.ToneDispatcher;
import com.ainirobot.coreservice.client.permission.PermissionListener;
import com.ainirobot.coreservice.client.person.PersonListener;
import com.ainirobot.coreservice.client.robotsetting.RobotSettingListener;
import com.ainirobot.coreservice.client.surfaceshare.SurfaceShareListener;

public class MessageDispatcher {
    static final int MSG_ACTION = 1;
    static final int MSG_STATUS = 2;
    static final int MSG_TEXT = 3;
    static final int MSG_TONE = 4;
    static final int MSG_PERSON = 5;
    static final int MSG_SETTING = 6;
    static final int MSG_ACCOUNT = 7;
    static final int MSG_PERMISSION = 8;
    static final int MSG_SURFACE_SHARE = 9;
    private ThreadLocal<DispatchHandler> mHandlers = new ThreadLocal();
    private DispatchHandler mMainThreadHandler = new DispatchHandler(Looper.getMainLooper());

    private DispatchHandler getDispatcher(Looper looper) {
        DispatchHandler dispatchHandler = this.mHandlers.get();
        if (dispatchHandler == null) {
            if (looper != null) {
                dispatchHandler = new DispatchHandler(looper);
                this.mHandlers.set(dispatchHandler);
            } else if (Looper.myLooper() == null) {
                dispatchHandler = this.mMainThreadHandler;
            } else if (Looper.myLooper() == Looper.getMainLooper()) {
                this.mHandlers.set(this.mMainThreadHandler);
                dispatchHandler = this.mMainThreadHandler;
            } else {
                dispatchHandler = new DispatchHandler(Looper.myLooper());
                this.mHandlers.set(dispatchHandler);
            }
        }
        return dispatchHandler;
    }

    public ActionDispatcher obtainActionDispatcher(ActionListener listener) {
        return this.obtainActionDispatcher(null, listener);
    }

    public StatusDispatcher obtainStatusDispatcher(StatusListener listener) {
        return this.obtainStatusDispatcher(null, listener);
    }

    public TextDispatcher obtainTextDispatcher(TextListener listener) {
        return this.obtainTextDispatcher(null, listener);
    }

    public ToneDispatcher obtainToneDispatcher(ToneListener listener) {
        return this.obtainToneDispatcher(null, listener);
    }

    public PersonDispatcher obtainPersonDispatcher(PersonListener listener) {
        return this.obtainPersonDispatcher(null, listener);
    }

    public PermissionDispatcher obtainPermissionDispatcher(PermissionListener listener) {
        return PermissionDispatcher.obtain(null, listener);
    }

    public RobotSettingDispatcher obtainRobotSettingDispatcher(RobotSettingListener listener) {
        return this.obtainRobotSettingDispatcher(null, listener);
    }

    public SurfaceShareDispatcher obtainSurfaceShareDispatcher(SurfaceShareListener listener) {
        return this.obtainSurfaceShareDispatcher(null, listener);
    }

    public ActionDispatcher obtainActionDispatcher(Looper looper, ActionListener listener) {
        return ActionDispatcher.obtain(this.getDispatcher(looper), listener);
    }

    public StatusDispatcher obtainStatusDispatcher(Looper looper, StatusListener listener) {
        return StatusDispatcher.obtain(this.getDispatcher(looper), listener);
    }

    public TextDispatcher obtainTextDispatcher(Looper looper, TextListener listener) {
        return TextDispatcher.obtain(this.getDispatcher(looper), listener);
    }

    public ToneDispatcher obtainToneDispatcher(Looper looper, ToneListener listener) {
        return ToneDispatcher.obtain(this.getDispatcher(looper), listener);
    }

    public PersonDispatcher obtainPersonDispatcher(Looper looper, PersonListener listener) {
        return PersonDispatcher.obtain(this.getDispatcher(looper), listener);
    }

    public PermissionDispatcher obtainPermissionDispatcher(Looper looper, PermissionListener listener) {
        return PermissionDispatcher.obtain(this.getDispatcher(looper), listener);
    }

    public AccountDispatcher obtainAccountDispatcher(Looper looper, AccountListener listener) {
        return AccountDispatcher.obtain(this.getDispatcher(looper), listener);
    }

    public RobotSettingDispatcher obtainRobotSettingDispatcher(Looper looper, RobotSettingListener listener) {
        return RobotSettingDispatcher.obtain(this.getDispatcher(looper), listener);
    }

    public SurfaceShareDispatcher obtainSurfaceShareDispatcher(Looper looper, SurfaceShareListener listener) {
        return SurfaceShareDispatcher.obtain(this.getDispatcher(looper), listener);
    }

    public void unregisterStatusDispatcher(String id) {
        StatusDispatcher.unregister(id);
    }
}

